//[misk-testing-api](../../../index.md)/[misk.testing](../index.md)/[TestFixture](index.md)

# TestFixture

interface [TestFixture](index.md)

Interface for test fixtures that need to be reset between test runs, when the reuse injector feature is enabled.

This needs to be implemented by:

1. 
   stateful fakes which hold `var`s or mutable collections. The `reset` implementation should set the state to the initial values. In such case, prefer extending the `DelegatedPropertiesTestFixture` class instead.
2. 
   test dependencies interacting with external stores, such as databases or caches. The `reset` implementation needs to clear the store.

TestFixtures must be multibound in a Guice module to ensure that the test infrastructure can reset them between test runs. For example:

```kotlin
      bind<Clock>().to<FakeClock>()
    + multibind<TestFixture>().to<FakeClock>()
```

#### Inheritors

| |
|---|
| [FakeFixture](../-fake-fixture/index.md) |

## Functions

| Name | Summary |
|---|---|
| [reset](reset.md) | [jvm]<br>abstract fun [reset](reset.md)()<br>Called before each test run to reset the state of the fixture. |