//[misk-testing-api](../../../index.md)/[misk.testing](../index.md)/[FakeFixture](index.md)

# FakeFixture

[jvm]\
open class [FakeFixture](index.md) : [TestFixture](../-test-fixture/index.md)

Base class providing a mechanism to define properties in fakes that will automatically be reset between test runs. The properties are defined using the `resettable` function, which creates a resettable property delegate.

```kotlin
class FakeJwtVerifier @Inject constructor() : JwtVerifier, FakeFixture() {
  - private var succeeds = true
  + private var succeeds by resettable { true }

  // more methods
}
```

## Constructors

| | |
|---|---|
| [FakeFixture](-fake-fixture.md) | [jvm]<br>constructor() |

## Functions

| Name | Summary |
|---|---|
| [reset](reset.md) | [jvm]<br>open override fun [reset](reset.md)()<br>Called before each test run to reset the state of the fixture. |
| [resettable](resettable.md) | [jvm]<br>fun &lt;[T](resettable.md)&gt; [resettable](resettable.md)(initializer: () -&gt; [T](resettable.md)): [ResettablePropertyDelegate](../-resettable-property-delegate/index.md)&lt;[T](resettable.md)&gt; |