/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.redis;

import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.binder.LinkedBindingBuilder;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.distributed.serialization.Mapper;
import io.github.bucket4j.redis.jedis.cas.JedisBasedProxyManager;
import io.micrometer.core.instrument.MeterRegistry;
import java.lang.annotation.Annotation;
import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import redis.clients.jedis.UnifiedJedis;
import wisp.ratelimiting.RateLimiter;
import wisp.ratelimiting.bucket4j.Bucket4jRateLimiter;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u001d\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule;", "Lmisk/inject/KAbstractModule;", "additionalTtl", "Ljava/time/Duration;", "qualifier", "", "(Ljava/time/Duration;Ljava/lang/annotation/Annotation;)V", "configure", "", "RedisBucket4jRateLimiterProvider", "misk-rate-limiting-bucket4j-redis"})
@SourceDebugExtension(value={"SMAP\nRedisBucket4jRateLimiterModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n*L\n1#1,65:1\n49#2,2:66\n49#2,2:68\n*S KotlinDebug\n*F\n+ 1 RedisBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule\n*L\n31#1:66,2\n32#1:68,2\n*E\n"})
public final class RedisBucket4jRateLimiterModule
extends KAbstractModule {
    @NotNull
    private final Duration additionalTtl;
    @Nullable
    private final Annotation qualifier;

    @JvmOverloads
    public RedisBucket4jRateLimiterModule(@NotNull Duration additionalTtl, @Nullable Annotation qualifier) {
        Intrinsics.checkNotNullParameter((Object)additionalTtl, (String)"additionalTtl");
        this.additionalTtl = additionalTtl;
        this.qualifier = qualifier;
    }

    public /* synthetic */ RedisBucket4jRateLimiterModule(Duration duration, Annotation annotation, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 2) != 0) {
            annotation = null;
        }
        this(duration, annotation);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, Clock.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, MeterRegistry.class);
        Key unifiedJedisKey = this.qualifier == null ? Key.get(UnifiedJedis.class) : Key.get(UnifiedJedis.class, (Annotation)this.qualifier);
        this.requireBinding(unifiedJedisKey);
        Provider unifiedJedisProvider = this.binder().getProvider(unifiedJedisKey);
        Key rateLimiterKey = this.qualifier == null ? Key.get(RateLimiter.class) : Key.get(RateLimiter.class, (Annotation)this.qualifier);
        LinkedBindingBuilder linkedBindingBuilder = this.bind(rateLimiterKey);
        Intrinsics.checkNotNull((Object)unifiedJedisProvider);
        linkedBindingBuilder.toProvider((Provider)new RedisBucket4jRateLimiterProvider(this.additionalTtl, (Provider<UnifiedJedis>)unifiedJedisProvider));
    }

    @JvmOverloads
    public RedisBucket4jRateLimiterModule(@NotNull Duration additionalTtl) {
        Intrinsics.checkNotNullParameter((Object)additionalTtl, (String)"additionalTtl");
        this(additionalTtl, null, 2, null);
    }

    @JvmOverloads
    public RedisBucket4jRateLimiterModule() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule$RedisBucket4jRateLimiterProvider;", "Lcom/google/inject/Provider;", "Lwisp/ratelimiting/RateLimiter;", "additionalTtl", "Ljava/time/Duration;", "unifiedJedisProvider", "Lredis/clients/jedis/UnifiedJedis;", "(Ljava/time/Duration;Lcom/google/inject/Provider;)V", "getAdditionalTtl", "()Ljava/time/Duration;", "clock", "Ljava/time/Clock;", "getClock", "()Ljava/time/Clock;", "setClock", "(Ljava/time/Clock;)V", "metricsRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "getMetricsRegistry", "()Lio/micrometer/core/instrument/MeterRegistry;", "setMetricsRegistry", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "get", "misk-rate-limiting-bucket4j-redis"})
    private static final class RedisBucket4jRateLimiterProvider
    implements Provider<RateLimiter> {
        @NotNull
        private final Duration additionalTtl;
        @NotNull
        private final Provider<UnifiedJedis> unifiedJedisProvider;
        @Inject
        public Clock clock;
        @Inject
        public MeterRegistry metricsRegistry;

        public RedisBucket4jRateLimiterProvider(@NotNull Duration additionalTtl, @NotNull Provider<UnifiedJedis> unifiedJedisProvider) {
            Intrinsics.checkNotNullParameter((Object)additionalTtl, (String)"additionalTtl");
            Intrinsics.checkNotNullParameter(unifiedJedisProvider, (String)"unifiedJedisProvider");
            this.additionalTtl = additionalTtl;
            this.unifiedJedisProvider = unifiedJedisProvider;
        }

        @NotNull
        public final Duration getAdditionalTtl() {
            return this.additionalTtl;
        }

        @NotNull
        public final Clock getClock() {
            Clock clock = this.clock;
            if (clock != null) {
                return clock;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"clock");
            return null;
        }

        public final void setClock(@NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"<set-?>");
            this.clock = clock;
        }

        @NotNull
        public final MeterRegistry getMetricsRegistry() {
            MeterRegistry meterRegistry = this.metricsRegistry;
            if (meterRegistry != null) {
                return meterRegistry;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"metricsRegistry");
            return null;
        }

        public final void setMetricsRegistry(@NotNull MeterRegistry meterRegistry) {
            Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"<set-?>");
            this.metricsRegistry = meterRegistry;
        }

        @NotNull
        public RateLimiter get() {
            JedisBasedProxyManager proxyManager = ((JedisBasedProxyManager.JedisBasedProxyManagerBuilder)((JedisBasedProxyManager.JedisBasedProxyManagerBuilder)JedisBasedProxyManager.builderFor((UnifiedJedis)((UnifiedJedis)this.unifiedJedisProvider.get())).withClientSideConfig(ClientSideConfig.getDefault().withClientClock((TimeMeter)new ClockTimeMeter(this.getClock())))).withExpirationStrategy(ExpirationAfterWriteStrategy.basedOnTimeForRefillingBucketUpToMax((Duration)this.additionalTtl))).withKeyMapper(Mapper.STRING).build();
            Intrinsics.checkNotNull((Object)proxyManager);
            return (RateLimiter)new Bucket4jRateLimiter((ProxyManager)proxyManager, this.getClock(), this.getMetricsRegistry());
        }
    }
}

