/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.redis;

import com.google.inject.Provides;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.ExpirationAfterWriteStrategy;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.distributed.serialization.Mapper;
import io.github.bucket4j.redis.jedis.cas.JedisBasedProxyManager;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.inject.Singleton;
import java.time.Clock;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.UnifiedJedis;
import wisp.ratelimiting.RateLimiter;
import wisp.ratelimiting.bucket4j.Bucket4jRateLimiter;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule;", "Lmisk/inject/KAbstractModule;", "additionalTtl", "Ljava/time/Duration;", "(Ljava/time/Duration;)V", "configure", "", "providedRateLimiter", "Lwisp/ratelimiting/RateLimiter;", "clock", "Ljava/time/Clock;", "metricsRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "unifiedJedis", "Lredis/clients/jedis/UnifiedJedis;", "misk-rate-limiting-bucket4j-redis"})
@SourceDebugExtension(value={"SMAP\nRedisBucket4jRateLimiterModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedisBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n*L\n1#1,55:1\n49#2,2:56\n49#2,2:58\n49#2,2:60\n*S KotlinDebug\n*F\n+ 1 RedisBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/redis/RedisBucket4jRateLimiterModule\n*L\n29#1:56,2\n30#1:58,2\n31#1:60,2\n*E\n"})
public final class RedisBucket4jRateLimiterModule
extends KAbstractModule {
    @NotNull
    private final Duration additionalTtl;

    @JvmOverloads
    public RedisBucket4jRateLimiterModule(@NotNull Duration additionalTtl) {
        Intrinsics.checkNotNullParameter((Object)additionalTtl, (String)"additionalTtl");
        this.additionalTtl = additionalTtl;
    }

    public /* synthetic */ RedisBucket4jRateLimiterModule(Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(5L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        this(duration);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, Clock.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, MeterRegistry.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, UnifiedJedis.class);
    }

    @Provides
    @Singleton
    @NotNull
    public final RateLimiter providedRateLimiter(@NotNull Clock clock, @NotNull MeterRegistry metricsRegistry, @NotNull UnifiedJedis unifiedJedis) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)metricsRegistry, (String)"metricsRegistry");
        Intrinsics.checkNotNullParameter((Object)unifiedJedis, (String)"unifiedJedis");
        JedisBasedProxyManager proxyManager = ((JedisBasedProxyManager.JedisBasedProxyManagerBuilder)((JedisBasedProxyManager.JedisBasedProxyManagerBuilder)JedisBasedProxyManager.builderFor((UnifiedJedis)unifiedJedis).withClientSideConfig(ClientSideConfig.getDefault().withClientClock((TimeMeter)new ClockTimeMeter(clock)))).withExpirationStrategy(ExpirationAfterWriteStrategy.basedOnTimeForRefillingBucketUpToMax((Duration)this.additionalTtl))).withKeyMapper(Mapper.STRING).build();
        Intrinsics.checkNotNull((Object)proxyManager);
        return (RateLimiter)new Bucket4jRateLimiter((ProxyManager)proxyManager, clock, metricsRegistry);
    }

    @JvmOverloads
    public RedisBucket4jRateLimiterModule() {
        this(null, 1, null);
    }
}

