/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.mysql;

import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.ratelimiting.RateLimitPrunerMetrics;
import wisp.ratelimiting.bucket4j.Bucket4jPruner;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"BK\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lmisk/ratelimiting/bucket4j/mysql/MySQLBucketPruner;", "Lwisp/ratelimiting/bucket4j/Bucket4jPruner;", "clock", "Ljava/time/Clock;", "dataSource", "Ljavax/sql/DataSource;", "idColumn", "", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "stateColumn", "tableName", "isMySQL8", "", "pageSize", "", "(Ljava/time/Clock;Ljavax/sql/DataSource;Ljava/lang/String;Lio/micrometer/core/instrument/MeterRegistry;Ljava/lang/String;Ljava/lang/String;ZJ)V", "clockTimeMeter", "Lwisp/ratelimiting/bucket4j/ClockTimeMeter;", "getClockTimeMeter", "()Lwisp/ratelimiting/bucket4j/ClockTimeMeter;", "deleteStatement", "lockingClause", "pageStatement", "prunerMetrics", "Lwisp/ratelimiting/RateLimitPrunerMetrics;", "isResultSetEmpty", "resultSet", "Ljava/sql/ResultSet;", "prune", "", "pruneLoop", "connection", "Ljava/sql/Connection;", "Companion", "misk-rate-limiting-bucket4j-mysql"})
@SourceDebugExtension(value={"SMAP\nMySQLBucketPruner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLBucketPruner.kt\nmisk/ratelimiting/bucket4j/mysql/MySQLBucketPruner\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,133:1\n17#2,6:134\n12#3:140\n*S KotlinDebug\n*F\n+ 1 MySQLBucketPruner.kt\nmisk/ratelimiting/bucket4j/mysql/MySQLBucketPruner\n*L\n61#1:134,6\n130#1:140\n*E\n"})
public final class MySQLBucketPruner
extends Bucket4jPruner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSource dataSource;
    @NotNull
    private final String idColumn;
    @NotNull
    private final String stateColumn;
    @NotNull
    private final ClockTimeMeter clockTimeMeter;
    @NotNull
    private final String deleteStatement;
    @NotNull
    private final String lockingClause;
    @NotNull
    private final String pageStatement;
    @NotNull
    private final RateLimitPrunerMetrics prunerMetrics;
    @NotNull
    private static final KLogger logger;

    @JvmOverloads
    public MySQLBucketPruner(@NotNull Clock clock, @NotNull DataSource dataSource, @NotNull String idColumn, @NotNull MeterRegistry meterRegistry, @NotNull String stateColumn, @NotNull String tableName, boolean isMySQL8, long pageSize) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)stateColumn, (String)"stateColumn");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.dataSource = dataSource;
        this.idColumn = idColumn;
        this.stateColumn = stateColumn;
        this.clockTimeMeter = new ClockTimeMeter(clock);
        this.deleteStatement = StringsKt.trimIndent((String)("\n    DELETE FROM " + tableName + "\n    WHERE " + this.idColumn + " = ?\n  "));
        this.lockingClause = isMySQL8 ? "FOR UPDATE SKIP LOCKED" : "FOR UPDATE";
        this.pageStatement = StringsKt.trimIndent((String)("\n    SELECT " + this.idColumn + ", " + this.stateColumn + "\n    FROM " + tableName + "\n    WHERE " + this.idColumn + " > ?\n    ORDER BY " + this.idColumn + "\n    LIMIT " + pageSize + "\n    " + this.lockingClause + "\n  "));
        this.prunerMetrics = new RateLimitPrunerMetrics(meterRegistry);
    }

    public /* synthetic */ MySQLBucketPruner(Clock clock, DataSource dataSource, String string, MeterRegistry meterRegistry, String string2, String string3, boolean bl, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            bl = false;
        }
        if ((n & 0x80) != 0) {
            l = 1000L;
        }
        this(clock, dataSource, string, meterRegistry, string2, string3, bl, l);
    }

    @NotNull
    public ClockTimeMeter getClockTimeMeter() {
        return this.clockTimeMeter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prune() {
        try (Connection connection = this.dataSource.getConnection();){
            connection.setAutoCommit(false);
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)connection);
            this.pruneLoop(connection);
            long millisTaken = System.currentTimeMillis() - start$iv;
            this.prunerMetrics.getPruningDuration().record((double)millisTaken);
        }
    }

    private final void pruneLoop(Connection connection) {
        String cursor = "";
        while (true) {
            String key;
            PreparedStatement fetchPageStatement = connection.prepareStatement(this.pageStatement);
            fetchPageStatement.setString(1, cursor);
            ResultSet resultSet = fetchPageStatement.executeQuery();
            Intrinsics.checkNotNull((Object)resultSet);
            if (this.isResultSetEmpty(resultSet)) break;
            int deletedBuckets = 0;
            while (true) {
                RemoteBucketState remoteBucketState;
                key = resultSet.getString(this.idColumn);
                byte[] stateBytes = resultSet.getBytes(this.stateColumn);
                try {
                    Intrinsics.checkNotNull((Object)stateBytes);
                    remoteBucketState = this.deserializeState(stateBytes);
                }
                catch (Exception e) {
                    logger.warn((Throwable)e, (Function0)new Function0<Object>(key){
                        final /* synthetic */ String $key;
                        {
                            this.$key = $key;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Failed to deserialize state column for key " + this.$key;
                        }
                    });
                    continue;
                }
                RemoteBucketState state2 = remoteBucketState;
                if (this.isBucketStale(state2)) {
                    PreparedStatement deleteBucketStatement = connection.prepareStatement(this.deleteStatement);
                    deleteBucketStatement.setString(1, key);
                    deleteBucketStatement.execute();
                    ++deletedBuckets;
                }
                if (this.isResultSetEmpty(resultSet)) break;
            }
            Intrinsics.checkNotNull((Object)key);
            cursor = key;
            connection.commit();
            this.prunerMetrics.getBucketsPruned().increment((double)deletedBuckets);
        }
    }

    private final boolean isResultSetEmpty(ResultSet resultSet) {
        boolean bl;
        try {
            bl = !resultSet.next();
        }
        catch (SQLException sQLException) {
            bl = true;
        }
        return bl;
    }

    @JvmOverloads
    public MySQLBucketPruner(@NotNull Clock clock, @NotNull DataSource dataSource, @NotNull String idColumn, @NotNull MeterRegistry meterRegistry, @NotNull String stateColumn, @NotNull String tableName, boolean isMySQL8) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)stateColumn, (String)"stateColumn");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this(clock, dataSource, idColumn, meterRegistry, stateColumn, tableName, isMySQL8, 0L, 128, null);
    }

    @JvmOverloads
    public MySQLBucketPruner(@NotNull Clock clock, @NotNull DataSource dataSource, @NotNull String idColumn, @NotNull MeterRegistry meterRegistry, @NotNull String stateColumn, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)stateColumn, (String)"stateColumn");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this(clock, dataSource, idColumn, meterRegistry, stateColumn, tableName, false, 0L, 192, null);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(MySQLBucketPruner.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lmisk/ratelimiting/bucket4j/mysql/MySQLBucketPruner$Companion;", "", "()V", "logger", "Lmu/KLogger;", "misk-rate-limiting-bucket4j-mysql"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

