/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.mysql;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.jdbc.BucketTableSettings;
import io.github.bucket4j.distributed.jdbc.PrimaryKeyMapper;
import io.github.bucket4j.distributed.jdbc.SQLProxyConfiguration;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.mysql.MySQLSelectForUpdateBasedProxyManager;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.inject.KAbstractModule;
import misk.jdbc.DataSourceService;
import misk.ratelimiting.bucket4j.mysql.MySQLBucketPruner;
import org.jetbrains.annotations.NotNull;
import wisp.ratelimiting.RateLimitPruner;
import wisp.ratelimiting.RateLimiter;
import wisp.ratelimiting.bucket4j.Bucket4jRateLimiter;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\b\u0007\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmisk/ratelimiting/bucket4j/mysql/MySQLBucket4jRateLimiterModule;", "Lmisk/inject/KAbstractModule;", "qualifier", "Lkotlin/reflect/KClass;", "", "tableName", "", "idColumn", "stateColumn", "prunerPageSize", "", "(Lkotlin/reflect/KClass;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)V", "configure", "", "providedPruner", "Lwisp/ratelimiting/RateLimitPruner;", "clock", "Ljava/time/Clock;", "injector", "Lcom/google/inject/Injector;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "providedRateLimiter", "Lwisp/ratelimiting/RateLimiter;", "misk-rate-limiting-bucket4j-mysql"})
@SourceDebugExtension(value={"SMAP\nMySQLBucket4jRateLimiterModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MySQLBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/mysql/MySQLBucket4jRateLimiterModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 3 Guice.kt\nmisk/inject/GuiceKt\n*L\n1#1,71:1\n49#2,2:72\n49#2,2:74\n96#3:76\n96#3:77\n96#3:78\n*S KotlinDebug\n*F\n+ 1 MySQLBucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/mysql/MySQLBucket4jRateLimiterModule\n*L\n31#1:72,2\n32#1:74,2\n33#1:76\n42#1:77\n59#1:78\n*E\n"})
public final class MySQLBucket4jRateLimiterModule
extends KAbstractModule {
    @NotNull
    private final KClass<? extends Annotation> qualifier;
    @NotNull
    private final String tableName;
    @NotNull
    private final String idColumn;
    @NotNull
    private final String stateColumn;
    private final long prunerPageSize;

    @JvmOverloads
    public MySQLBucket4jRateLimiterModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull String tableName, @NotNull String idColumn, @NotNull String stateColumn, long prunerPageSize) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)stateColumn, (String)"stateColumn");
        this.qualifier = qualifier;
        this.tableName = tableName;
        this.idColumn = idColumn;
        this.stateColumn = stateColumn;
        this.prunerPageSize = prunerPageSize;
    }

    public /* synthetic */ MySQLBucket4jRateLimiterModule(KClass kClass, String string, String string2, String string3, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l = 1000L;
        }
        this((KClass<? extends Annotation>)kClass, string, string2, string3, l);
    }

    protected void configure() {
        Key key;
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, Clock.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, MeterRegistry.class);
        KClass<? extends Annotation> a$iv = this.qualifier;
        boolean $i$f$keyOf = false;
        if (a$iv == null) {
            Key key2 = Key.get(DataSourceService.class);
            key = key2;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"get(...)");
        } else {
            Key key3 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv));
            key = key3;
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"get(...)");
        }
        this.requireBinding(key);
    }

    @Provides
    @Singleton
    @NotNull
    public final RateLimiter providedRateLimiter(@NotNull Clock clock, @NotNull Injector injector, @NotNull MeterRegistry meterRegistry) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        KClass<? extends Annotation> a$iv = this.qualifier;
        boolean $i$f$keyOf = false;
        if (a$iv == null) {
            Key key2 = Key.get(DataSourceService.class);
            key = key2;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"get(...)");
        } else {
            Key key3 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv));
            key = key3;
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"get(...)");
        }
        DataSourceService dataSourceService = (DataSourceService)injector.getInstance(key);
        SQLProxyConfiguration sqlConfiguration = SQLProxyConfiguration.builder().withPrimaryKeyMapper(PrimaryKeyMapper.STRING).withTableSettings(BucketTableSettings.customSettings((String)this.tableName, (String)this.idColumn, (String)this.stateColumn)).withClientSideConfig(ClientSideConfig.getDefault().withClientClock((TimeMeter)new ClockTimeMeter(clock))).build(dataSourceService.getDataSource());
        ProxyManager proxyManager = (ProxyManager)new MySQLSelectForUpdateBasedProxyManager(sqlConfiguration);
        return (RateLimiter)new Bucket4jRateLimiter(proxyManager, clock, meterRegistry);
    }

    @Provides
    @Singleton
    @NotNull
    public final RateLimitPruner providedPruner(@NotNull Clock clock, @NotNull Injector injector, @NotNull MeterRegistry meterRegistry) {
        Key key;
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)injector, (String)"injector");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        KClass<? extends Annotation> a$iv = this.qualifier;
        boolean $i$f$keyOf = false;
        if (a$iv == null) {
            Key key2 = Key.get(DataSourceService.class);
            key = key2;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"get(...)");
        } else {
            Key key3 = Key.get(DataSourceService.class, (Class)JvmClassMappingKt.getJavaClass(a$iv));
            key = key3;
            Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"get(...)");
        }
        DataSourceService dataSourceService = (DataSourceService)injector.getInstance(key);
        return (RateLimitPruner)new MySQLBucketPruner(clock, dataSourceService.getDataSource(), this.idColumn, meterRegistry, this.stateColumn, this.tableName, false, this.prunerPageSize, 64, null);
    }

    @JvmOverloads
    public MySQLBucket4jRateLimiterModule(@NotNull KClass<? extends Annotation> qualifier, @NotNull String tableName, @NotNull String idColumn, @NotNull String stateColumn) {
        Intrinsics.checkNotNullParameter(qualifier, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)idColumn, (String)"idColumn");
        Intrinsics.checkNotNullParameter((Object)stateColumn, (String)"stateColumn");
        this(qualifier, tableName, idColumn, stateColumn, 0L, 16, null);
    }
}

