/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.dynamodb.v1;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import com.amazonaws.services.dynamodbv2.document.DynamoDB;
import com.amazonaws.services.dynamodbv2.document.Expected;
import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.Page;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.internal.PageIterable;
import com.amazonaws.services.dynamodbv2.document.spec.DeleteItemSpec;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.micrometer.core.instrument.MeterRegistry;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.ratelimiting.bucket4j.dynamodb.v1.DynamoDbV1BucketPruner;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.ratelimiting.RateLimitPrunerMetrics;
import wisp.ratelimiting.bucket4j.Bucket4jPruner;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1BucketPruner;", "Lwisp/ratelimiting/bucket4j/Bucket4jPruner;", "clock", "Ljava/time/Clock;", "amazonDynamoDB", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "tableName", "", "pageSize", "", "(Ljava/time/Clock;Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;Lio/micrometer/core/instrument/MeterRegistry;Ljava/lang/String;I)V", "clockTimeMeter", "Lwisp/ratelimiting/bucket4j/ClockTimeMeter;", "getClockTimeMeter", "()Lwisp/ratelimiting/bucket4j/ClockTimeMeter;", "dynamoDB", "Lcom/amazonaws/services/dynamodbv2/document/DynamoDB;", "prunerMetrics", "Lwisp/ratelimiting/RateLimitPrunerMetrics;", "prune", "", "pruneLoop", "Companion", "misk-rate-limiting-bucket4j-dynamodb-v1"})
@SourceDebugExtension(value={"SMAP\nDynamoDbV1BucketPruner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoDbV1BucketPruner.kt\nmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1BucketPruner\n+ 2 Timing.kt\nkotlin/system/TimingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 5 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,81:1\n17#2,6:82\n1855#3:88\n1856#3:91\n32#4,2:89\n12#5:92\n*S KotlinDebug\n*F\n+ 1 DynamoDbV1BucketPruner.kt\nmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1BucketPruner\n*L\n30#1:82,6\n43#1:88\n43#1:91\n44#1:89,2\n75#1:92\n*E\n"})
public final class DynamoDbV1BucketPruner
extends Bucket4jPruner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tableName;
    private final int pageSize;
    @NotNull
    private final ClockTimeMeter clockTimeMeter;
    @NotNull
    private final DynamoDB dynamoDB;
    @NotNull
    private final RateLimitPrunerMetrics prunerMetrics;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final String HASH_ATTRIBUTE = "key";
    @NotNull
    private static final String STATE_ATTRIBUTE = "state";

    @JvmOverloads
    public DynamoDbV1BucketPruner(@NotNull Clock clock, @NotNull AmazonDynamoDB amazonDynamoDB, @NotNull MeterRegistry meterRegistry, @NotNull String tableName, int pageSize) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)amazonDynamoDB, (String)"amazonDynamoDB");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.tableName = tableName;
        this.pageSize = pageSize;
        this.clockTimeMeter = new ClockTimeMeter(clock);
        this.dynamoDB = new DynamoDB(amazonDynamoDB);
        this.prunerMetrics = new RateLimitPrunerMetrics(meterRegistry);
    }

    public /* synthetic */ DynamoDbV1BucketPruner(Clock clock, AmazonDynamoDB amazonDynamoDB, MeterRegistry meterRegistry, String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 1000;
        }
        this(clock, amazonDynamoDB, meterRegistry, string, n);
    }

    @NotNull
    public ClockTimeMeter getClockTimeMeter() {
        return this.clockTimeMeter;
    }

    public void prune() {
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        this.pruneLoop();
        long millisTaken = System.currentTimeMillis() - start$iv;
        this.prunerMetrics.getPruningDuration().record((double)millisTaken);
    }

    private final void pruneLoop() {
        Table table = this.dynamoDB.getTable(this.tableName);
        ScanSpec scanSpec = new ScanSpec().withMaxPageSize(this.pageSize).withConsistentRead(Boolean.valueOf(true));
        ItemCollection result = table.scan(scanSpec);
        PageIterable pageIterable = result.pages();
        Intrinsics.checkNotNullExpressionValue((Object)pageIterable, (String)"result.pages()");
        Iterable $this$forEach$iv = (Iterable)pageIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterator $this$forEach$iv2;
            Page page = (Page)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)page.iterator(), (String)"page.iterator()");
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2;
            while (iterator.hasNext()) {
                Object $this$pruneLoop_u24lambda_u244_u24lambda_u243_u24lambda_u241;
                ByteBuffer byteBuffer;
                Object element$iv2 = iterator.next();
                Item item = (Item)element$iv2;
                boolean bl2 = false;
                ByteBuffer byteBuffer2 = byteBuffer = item.getByteBuffer(STATE_ATTRIBUTE);
                if (byteBuffer2 == null) {
                    $this$pruneLoop_u24lambda_u244_u24lambda_u243_u24lambda_u241 = this;
                    boolean bl3 = false;
                    logger.warn((Function0)new Function0<Object>(item){
                        final /* synthetic */ Item $item;
                        {
                            this.$item = $item;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Row " + this.$item.getString("key") + " is missing its state attribute, this should never happen. Skipping";
                        }
                    });
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"item.getByteBuffer(STATE\u2026   return@inner\n        }");
                ByteBuffer stateBytes2 = byteBuffer;
                byte[] byArray = stateBytes2.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"stateBytes.array()");
                RemoteBucketState state = this.deserializeState(byArray);
                if (!this.isBucketStale(state)) continue;
                Object object = $this$pruneLoop_u24lambda_u244_u24lambda_u243_u24lambda_u241 = item.getString(HASH_ATTRIBUTE);
                if (object == null) {
                    DynamoDbV1BucketPruner $this$pruneLoop_u24lambda_u244_u24lambda_u243_u24lambda_u242 = this;
                    boolean bl4 = false;
                    logger.warn((Function0)pruneLoop.1.1.id.1.1.INSTANCE);
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"item.getString(HASH_ATTR\u2026 return@inner\n          }");
                Object id2 = $this$pruneLoop_u24lambda_u244_u24lambda_u243_u24lambda_u241;
                Expected[] bl3 = new Expected[]{new Expected(STATE_ATTRIBUTE).eq((Object)stateBytes2)};
                DeleteItemSpec deleteRequest = new DeleteItemSpec().withPrimaryKey(HASH_ATTRIBUTE, id2).withExpected(bl3).withReturnValues(ReturnValue.ALL_OLD);
                DeleteItemOutcome deletionResult = table.deleteItem(deleteRequest);
                Map map = deletionResult.getDeleteItemResult().getAttributes();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"deletionResult.deleteItemResult.attributes");
                if (!(!map.isEmpty())) continue;
                this.prunerMetrics.getBucketsPruned().increment();
            }
        }
    }

    @JvmOverloads
    public DynamoDbV1BucketPruner(@NotNull Clock clock, @NotNull AmazonDynamoDB amazonDynamoDB, @NotNull MeterRegistry meterRegistry, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)amazonDynamoDB, (String)"amazonDynamoDB");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this(clock, amazonDynamoDB, meterRegistry, tableName, 0, 16, null);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(DynamoDbV1BucketPruner.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1BucketPruner$Companion;", "", "()V", "HASH_ATTRIBUTE", "", "STATE_ATTRIBUTE", "logger", "Lmu/KLogger;", "misk-rate-limiting-bucket4j-dynamodb-v1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

