/*
 * Decompiled with CFR 0.152.
 */
package misk.ratelimiting.bucket4j.dynamodb.v1;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.google.inject.Provides;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.ProxyManager;
import io.github.bucket4j.dynamodb.v1.BaseDynamoDBProxyManager;
import io.github.bucket4j.dynamodb.v1.DynamoDBProxyManager;
import io.micrometer.core.instrument.MeterRegistry;
import jakarta.inject.Singleton;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.inject.KAbstractModule;
import misk.ratelimiting.bucket4j.dynamodb.v1.DynamoDbV1BucketPruner;
import org.jetbrains.annotations.NotNull;
import wisp.ratelimiting.RateLimitPruner;
import wisp.ratelimiting.RateLimiter;
import wisp.ratelimiting.bucket4j.Bucket4jRateLimiter;
import wisp.ratelimiting.bucket4j.ClockTimeMeter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1Bucket4jRateLimiterModule;", "Lmisk/inject/KAbstractModule;", "tableName", "", "prunerPageSize", "", "(Ljava/lang/String;I)V", "configure", "", "providedPruner", "Lwisp/ratelimiting/RateLimitPruner;", "clock", "Ljava/time/Clock;", "dynamoDB", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "providedRateLimiter", "Lwisp/ratelimiting/RateLimiter;", "misk-rate-limiting-bucket4j-dynamodb-v1"})
@SourceDebugExtension(value={"SMAP\nDynamoDbV1Bucket4jRateLimiterModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoDbV1Bucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1Bucket4jRateLimiterModule\n+ 2 KAbstractModule.kt\nmisk/inject/KAbstractModule\n*L\n1#1,59:1\n49#2,2:60\n49#2,2:62\n49#2,2:64\n*S KotlinDebug\n*F\n+ 1 DynamoDbV1Bucket4jRateLimiterModule.kt\nmisk/ratelimiting/bucket4j/dynamodb/v1/DynamoDbV1Bucket4jRateLimiterModule\n*L\n25#1:60,2\n26#1:62,2\n27#1:64,2\n*E\n"})
public final class DynamoDbV1Bucket4jRateLimiterModule
extends KAbstractModule {
    @NotNull
    private final String tableName;
    private final int prunerPageSize;

    @JvmOverloads
    public DynamoDbV1Bucket4jRateLimiterModule(@NotNull String tableName, int prunerPageSize) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this.tableName = tableName;
        this.prunerPageSize = prunerPageSize;
    }

    public /* synthetic */ DynamoDbV1Bucket4jRateLimiterModule(String string, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        this(string, n);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, Clock.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AmazonDynamoDB.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, MeterRegistry.class);
    }

    @Provides
    @Singleton
    @NotNull
    public final RateLimiter providedRateLimiter(@NotNull Clock clock, @NotNull AmazonDynamoDB dynamoDB, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dynamoDB, (String)"dynamoDB");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        BaseDynamoDBProxyManager baseDynamoDBProxyManager = DynamoDBProxyManager.stringKey((AmazonDynamoDB)dynamoDB, (String)this.tableName, (ClientSideConfig)ClientSideConfig.getDefault().withClientClock((TimeMeter)new ClockTimeMeter(clock)));
        Intrinsics.checkNotNullExpressionValue((Object)baseDynamoDBProxyManager, (String)"stringKey(\n      dynamoD\u2026ckTimeMeter(clock))\n    )");
        ProxyManager proxyManager = (ProxyManager)baseDynamoDBProxyManager;
        return (RateLimiter)new Bucket4jRateLimiter(proxyManager, clock, meterRegistry);
    }

    @Provides
    @Singleton
    @NotNull
    public final RateLimitPruner providedPruner(@NotNull Clock clock, @NotNull AmazonDynamoDB dynamoDB, @NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)dynamoDB, (String)"dynamoDB");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        return (RateLimitPruner)new DynamoDbV1BucketPruner(clock, dynamoDB, meterRegistry, this.tableName, this.prunerPageSize);
    }

    @JvmOverloads
    public DynamoDbV1Bucket4jRateLimiterModule(@NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        this(tableName, 0, 2, null);
    }
}

