/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.DockerCmdExecFactory;
import com.github.dockerjava.core.DockerClientBuilder;
import com.github.dockerjava.netty.NettyDockerCmdExecFactory;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.gson.Gson;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import misk.hibernate.DataSourceConfig;
import misk.hibernate.DataSourceType;
import misk.hibernate.DockerVitessCluster;
import misk.hibernate.StartVitessService;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lmisk/hibernate/StartVitessService;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "config", "Lmisk/hibernate/DataSourceConfig;", "(Lmisk/hibernate/DataSourceConfig;)V", "getConfig", "()Lmisk/hibernate/DataSourceConfig;", "shutDown", "", "startUp", "Companion", "misk-hibernate-testing"})
public final class StartVitessService
extends AbstractIdleService {
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private static final KLogger logger;
    @NotNull
    private static final DockerClient docker;
    @NotNull
    private static final Gson gson;
    private static final LoadingCache<DataSourceConfig, DockerVitessCluster> clusters;
    public static final Companion Companion;

    protected void startUp() {
        if (this.config.getType() != DataSourceType.VITESS) {
            return;
        }
        ((DockerVitessCluster)clusters.get((Object)this.config)).start();
    }

    protected void shutDown() {
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    public StartVitessService(@NotNull DataSourceConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
    }

    static {
        Companion = new Companion(null);
        logger = KotlinLogging.INSTANCE.logger((Function0)Companion.logger.1.INSTANCE);
        DockerClient dockerClient = DockerClientBuilder.getInstance().withDockerCmdExecFactory((DockerCmdExecFactory)new NettyDockerCmdExecFactory()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)dockerClient, (String)"DockerClientBuilder.getI\u2026ctory())\n        .build()");
        docker = dockerClient;
        gson = new Gson();
        clusters = CacheBuilder.newBuilder().removalListener((RemovalListener)Companion.clusters.1.INSTANCE).build(CacheLoader.from((Function)Companion.clusters.2.INSTANCE));
        Runtime.getRuntime().addShutdownHook(new Thread(Companion.1.INSTANCE));
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002RQ\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lmisk/hibernate/StartVitessService$Companion;", "", "()V", "clusters", "Lcom/google/common/cache/LoadingCache;", "Lmisk/hibernate/DataSourceConfig;", "kotlin.jvm.PlatformType", "Lmisk/hibernate/DockerVitessCluster;", "getClusters", "()Lcom/google/common/cache/LoadingCache;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "misk-hibernate-testing"})
    public static final class Companion {
        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        @NotNull
        public final DockerClient getDocker() {
            return docker;
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        public final LoadingCache<DataSourceConfig, DockerVitessCluster> getClusters() {
            return clusters;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

