/*
 * Decompiled with CFR 0.152.
 */
package misk.hibernate;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import com.google.gson.Gson;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.streams.jdk8.StreamsKt;
import misk.hibernate.DataSourceConfig;
import misk.hibernate.LogContainerResultCallback;
import misk.hibernate.StartVitessService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/hibernate/DockerVitessCluster;", "", "config", "Lmisk/hibernate/DataSourceConfig;", "docker", "Lcom/github/dockerjava/api/DockerClient;", "gson", "Lcom/google/gson/Gson;", "(Lmisk/hibernate/DataSourceConfig;Lcom/github/dockerjava/api/DockerClient;Lcom/google/gson/Gson;)V", "getConfig", "()Lmisk/hibernate/DataSourceConfig;", "containerId", "", "getDocker", "()Lcom/github/dockerjava/api/DockerClient;", "getGson", "()Lcom/google/gson/Gson;", "isRunning", "", "start", "", "stop", "misk-hibernate-testing"})
public final class DockerVitessCluster {
    private String containerId;
    private boolean isRunning;
    @NotNull
    private final DataSourceConfig config;
    @NotNull
    private final DockerClient docker;
    @NotNull
    private final Gson gson;

    /*
     * WARNING - void declaration
     */
    public final void start() {
        Object it;
        Iterable $receiver$iv$iv;
        Object object;
        Collection collection;
        void $receiver$iv$iv2;
        void $receiver$iv$iv3;
        Iterable $receiver$iv;
        if (this.isRunning) {
            return;
        }
        this.isRunning = true;
        Path schemaDir = Paths.get(this.config.getVitess_schema_dir(), new String[0]);
        boolean bl = Files.isDirectory(schemaDir, new LinkOption[0]);
        if (!bl) {
            String string = "can't find directory " + this.config.getVitess_schema_dir();
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Stream<Path> stream = Files.list(schemaDir);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"Files.list(schemaDir)");
        Iterable iterable = $receiver$iv = (Iterable)StreamsKt.toList(stream);
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv3) {
            Path it2 = (Path)element$iv$iv;
            if (!Files.isDirectory(it2, new LinkOption[0])) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List keyspaceDirs = (List)destination$iv$iv;
        Iterable $receiver$iv2 = keyspaceDirs;
        destination$iv$iv = $receiver$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void it3;
            Path $i$a$1$filter = (Path)item$iv$iv;
            collection = destination$iv$iv2;
            void v1 = it3;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            object = v1.getFileName();
            collection.add(object);
        }
        String keyspaces = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Iterable $receiver$iv3 = keyspaceDirs;
        destination$iv$iv2 = $receiver$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Path $i$a$1$map = (Path)item$iv$iv;
            collection = destination$iv$iv3;
            object = it.resolve("vschema.json");
            collection.add(object);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Path)item$iv$iv;
            collection = destination$iv$iv3;
            object = (Map)this.gson.fromJson((Reader)new FileReader(it.toFile()), Map.class);
            collection.add(object);
        }
        $receiver$iv3 = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object object2;
            it = (Map)item$iv$iv;
            collection = destination$iv$iv3;
            Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
            String string = "sharded";
            Object v = object2.get(string);
            if (v == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
            }
            object = (Boolean)v != false ? "2" : "1";
            collection.add(object);
        }
        String shardCounts = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv3), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        Volume schemaVolume = new Volume("/vt/src/vitess.io/vitess/schema");
        ExposedPort httpPort = ExposedPort.tcp((int)27000);
        Integer n = this.config.getPort();
        ExposedPort grpcPort = ExposedPort.tcp((int)(n != null ? n : 27001));
        Ports ports = new Ports();
        ExposedPort exposedPort = grpcPort;
        Intrinsics.checkExpressionValueIsNotNull((Object)exposedPort, (String)"grpcPort");
        ports.bind(grpcPort, Ports.Binding.bindPort((int)exposedPort.getPort()));
        ExposedPort exposedPort2 = httpPort;
        Intrinsics.checkExpressionValueIsNotNull((Object)exposedPort2, (String)"httpPort");
        ports.bind(httpPort, Ports.Binding.bindPort((int)exposedPort2.getPort()));
        Object[] cmd = new String[]{"/vt/bin/vttestserver", "-alsologtostderr", "-port=27000", "-web_dir=web/vtctld/app", "-web_dir2=web/vtctld2/app", "-mysql_bind_host=0.0.0.0", "-schema_dir=schema", "-keyspaces=" + keyspaces, "-num_shards=" + shardCounts};
        StartVitessService.Companion.getLogger().info("Starting Vitess cluster with command: " + ArraysKt.joinToString$default((Object[])cmd, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        CreateContainerResponse createContainerResponse = this.docker.createContainerCmd("vitess/base").withCmd(ArraysKt.toList((Object[])cmd)).withVolumes(new Volume[]{schemaVolume}).withBinds(new Bind[]{new Bind(((Object)schemaDir.toAbsolutePath()).toString(), schemaVolume)}).withExposedPorts(new ExposedPort[]{httpPort, grpcPort}).withPortBindings(ports).withTty(Boolean.valueOf(true)).exec();
        Intrinsics.checkExpressionValueIsNotNull((Object)createContainerResponse, (String)"docker.createContainerCm\u2026Tty(true)\n        .exec()");
        String string = this.containerId = createContainerResponse.getId();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String containerId = string;
        this.docker.startContainerCmd(containerId).exec();
        ((LogContainerResultCallback)this.docker.logContainerCmd(containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withFollowStream(Boolean.valueOf(true)).withSince(Integer.valueOf(0)).exec((ResultCallback)new LogContainerResultCallback())).awaitStarted();
        StartVitessService.Companion.getLogger().info("Started Vitess with container id " + containerId);
    }

    public final void stop() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        String string = this.containerId;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        this.docker.removeContainerCmd(string).withForce(Boolean.valueOf(true)).exec();
        StartVitessService.Companion.getLogger().info("Killed Vitess cluster with container id " + this.containerId);
    }

    @NotNull
    public final DataSourceConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final DockerClient getDocker() {
        return this.docker;
    }

    @NotNull
    public final Gson getGson() {
        return this.gson;
    }

    public DockerVitessCluster(@NotNull DataSourceConfig config, @NotNull DockerClient docker, @NotNull Gson gson) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)docker, (String)"docker");
        Intrinsics.checkParameterIsNotNull((Object)gson, (String)"gson");
        this.config = config;
        this.docker = docker;
        this.gson = gson;
    }
}

