/*
 * Decompiled with CFR 0.152.
 */
package misk.exceptions.dynamodb;

import com.amazonaws.services.dynamodbv2.model.CancellationReason;
import com.amazonaws.services.dynamodbv2.model.TransactionCanceledException;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.web.Response;
import misk.web.ResponseBody;
import misk.web.ResponseExtensionsKt;
import misk.web.exceptions.ExceptionMapper;
import misk.web.exceptions.GrpcErrorResponse;
import okhttp3.Headers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.event.Level;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lmisk/exceptions/dynamodb/TransactionCanceledExceptionMapper;", "Lmisk/web/exceptions/ExceptionMapper;", "Lcom/amazonaws/services/dynamodbv2/model/TransactionCanceledException;", "()V", "resourceContentionCancellationReasonCodes", "", "", "loggingLevel", "Lorg/slf4j/event/Level;", "th", "toResponse", "Lmisk/web/Response;", "Lmisk/web/ResponseBody;", "isFromResourceContention", "", "Companion", "misk-exceptions-dynamodb"})
@SourceDebugExtension(value={"SMAP\nTransactionCanceledExceptionMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionCanceledExceptionMapper.kt\nmisk/exceptions/dynamodb/TransactionCanceledExceptionMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1747#2,3:66\n*S KotlinDebug\n*F\n+ 1 TransactionCanceledExceptionMapper.kt\nmisk/exceptions/dynamodb/TransactionCanceledExceptionMapper\n*L\n31#1:66,3\n*E\n"})
public final class TransactionCanceledExceptionMapper
implements ExceptionMapper<TransactionCanceledException> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> resourceContentionCancellationReasonCodes;
    @NotNull
    private static final Headers HEADERS = Headers.Companion.of(MapsKt.toMap((Iterable)CollectionsKt.listOf((Object)TuplesKt.to((Object)"Content-Type", (Object)"text/plain;charset=utf-8"))));

    @Inject
    public TransactionCanceledExceptionMapper() {
        Object[] objectArray = new String[]{"ConditionalCheckFailed", "TransactionConflict"};
        this.resourceContentionCancellationReasonCodes = SetsKt.setOf((Object[])objectArray);
    }

    private final boolean isFromResourceContention(TransactionCanceledException $this$isFromResourceContention) {
        boolean bl;
        block3: {
            List list = $this$isFromResourceContention.getCancellationReasons();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCancellationReasons(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CancellationReason it = (CancellationReason)element$iv;
                    boolean bl2 = false;
                    if (!this.resourceContentionCancellationReasonCodes.contains(it.getCode())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public Response<ResponseBody> toResponse(@NotNull TransactionCanceledException th) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)th, (String)"th");
        if (this.isFromResourceContention(th)) {
            String message = "DynamoDB Resource Contention Exception: " + th;
            response = new Response((Object)ResponseExtensionsKt.toResponseBody((String)message), HEADERS, 503, null, 8, null);
        } else {
            String message = "Internal server error: " + th;
            response = new Response((Object)ResponseExtensionsKt.toResponseBody((String)message), HEADERS, 500, null, 8, null);
        }
        return response;
    }

    @NotNull
    public Level loggingLevel(@NotNull TransactionCanceledException th) {
        Intrinsics.checkNotNullParameter((Object)th, (String)"th");
        return this.isFromResourceContention(th) ? Level.INFO : Level.ERROR;
    }

    @Nullable
    public GrpcErrorResponse toGrpcResponse(@NotNull TransactionCanceledException th) {
        return ExceptionMapper.DefaultImpls.toGrpcResponse((ExceptionMapper)this, (Throwable)((Throwable)th));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmisk/exceptions/dynamodb/TransactionCanceledExceptionMapper$Companion;", "", "()V", "HEADERS", "Lokhttp3/Headers;", "getHEADERS", "()Lokhttp3/Headers;", "misk-exceptions-dynamodb"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Headers getHEADERS() {
            return HEADERS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

