/*
 * Decompiled with CFR 0.152.
 */
package misk.clustering.dynamo;

import com.google.common.util.concurrent.AbstractIdleService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Clock;
import java.time.Duration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import misk.clustering.Cluster;
import misk.clustering.DefaultCluster;
import misk.clustering.dynamo.DyClusterMember;
import misk.clustering.dynamo.DynamoClusterConfig;
import misk.clustering.dynamo.ForDynamoDbClusterWatching;
import misk.clustering.weights.ClusterWeightProvider;
import misk.tasks.RepeatedTaskQueue;
import misk.tasks.Status;
import misk.time.TimedKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Expression;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.internal.AttributeValues;
import software.amazon.awssdk.enhanced.dynamodb.model.Page;
import software.amazon.awssdk.enhanced.dynamodb.model.ScanEnhancedRequest;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;

@Singleton
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 #2\u00020\u0001:\u0001#B9\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\b\u0010 \u001a\u00020\u001bH\u0014J\b\u0010!\u001a\u00020\u001bH\u0014J\b\u0010\"\u001a\u00020\u001bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0017\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00190\u0019 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00190\u0019\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lmisk/clustering/dynamo/DynamoClusterWatcherTask;", "Lcom/google/common/util/concurrent/AbstractIdleService;", "taskQueue", "Lmisk/tasks/RepeatedTaskQueue;", "ddb", "Lsoftware/amazon/awssdk/services/dynamodb/DynamoDbClient;", "clock", "Ljava/time/Clock;", "clusterWeightProvider", "Lmisk/clustering/weights/ClusterWeightProvider;", "cluster", "Lmisk/clustering/DefaultCluster;", "dynamoClusterConfig", "Lmisk/clustering/dynamo/DynamoClusterConfig;", "(Lmisk/tasks/RepeatedTaskQueue;Lsoftware/amazon/awssdk/services/dynamodb/DynamoDbClient;Ljava/time/Clock;Lmisk/clustering/weights/ClusterWeightProvider;Lmisk/clustering/DefaultCluster;Lmisk/clustering/dynamo/DynamoClusterConfig;)V", "enhancedClient", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbEnhancedClient;", "kotlin.jvm.PlatformType", "podName", "", "prevMembers", "", "Lmisk/clustering/Cluster$Member;", "table", "Lsoftware/amazon/awssdk/enhanced/dynamodb/DynamoDbTable;", "Lmisk/clustering/dynamo/DyClusterMember;", "recordCurrentDynamoCluster", "", "recordCurrentDynamoCluster$misk_clustering_dynamodb", "run", "Lmisk/tasks/Status;", "run$misk_clustering_dynamodb", "shutDown", "startUp", "updateOurselfInDynamo", "Companion", "misk-clustering-dynamodb"})
@SourceDebugExtension(value={"SMAP\nDynamoClusterWatcherTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamoClusterWatcherTask.kt\nmisk/clustering/dynamo/DynamoClusterWatcherTask\n+ 2 Logging.kt\nwisp/logging/LoggingKt\n*L\n1#1,104:1\n12#2:105\n*S KotlinDebug\n*F\n+ 1 DynamoClusterWatcherTask.kt\nmisk/clustering/dynamo/DynamoClusterWatcherTask\n*L\n101#1:105\n*E\n"})
public final class DynamoClusterWatcherTask
extends AbstractIdleService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RepeatedTaskQueue taskQueue;
    @NotNull
    private final Clock clock;
    @NotNull
    private final ClusterWeightProvider clusterWeightProvider;
    @NotNull
    private final DefaultCluster cluster;
    @NotNull
    private final DynamoClusterConfig dynamoClusterConfig;
    private final DynamoDbEnhancedClient enhancedClient;
    private final DynamoDbTable<DyClusterMember> table;
    private final String podName;
    @NotNull
    private Set<Cluster.Member> prevMembers;
    private static final TableSchema<DyClusterMember> TABLE_SCHEMA = TableSchema.fromClass(DyClusterMember.class);
    @NotNull
    private static final KLogger logger;

    @Inject
    public DynamoClusterWatcherTask(@ForDynamoDbClusterWatching @NotNull RepeatedTaskQueue taskQueue, @NotNull DynamoDbClient ddb, @NotNull Clock clock, @NotNull ClusterWeightProvider clusterWeightProvider, @NotNull DefaultCluster cluster, @NotNull DynamoClusterConfig dynamoClusterConfig) {
        Intrinsics.checkNotNullParameter((Object)taskQueue, (String)"taskQueue");
        Intrinsics.checkNotNullParameter((Object)ddb, (String)"ddb");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)clusterWeightProvider, (String)"clusterWeightProvider");
        Intrinsics.checkNotNullParameter((Object)cluster, (String)"cluster");
        Intrinsics.checkNotNullParameter((Object)dynamoClusterConfig, (String)"dynamoClusterConfig");
        this.taskQueue = taskQueue;
        this.clock = clock;
        this.clusterWeightProvider = clusterWeightProvider;
        this.cluster = cluster;
        this.dynamoClusterConfig = dynamoClusterConfig;
        this.enhancedClient = DynamoDbEnhancedClient.builder().dynamoDbClient(ddb).build();
        this.table = this.enhancedClient.table(this.dynamoClusterConfig.getTable_name(), TABLE_SCHEMA);
        this.podName = System.getenv("MY_POD_NAME");
        this.prevMembers = CollectionsKt.toSet((Iterable)this.cluster.getSnapshot().getReadyMembers());
    }

    protected void startUp() {
        Duration duration = Duration.ofSeconds(this.dynamoClusterConfig.getUpdate_frequency_seconds());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        RepeatedTaskQueue.scheduleWithBackoff$default((RepeatedTaskQueue)this.taskQueue, (Duration)duration, null, null, null, (Function0)((Function0)new Function0<Status>(this){
            final /* synthetic */ DynamoClusterWatcherTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Status invoke() {
                return this.this$0.run$misk_clustering_dynamodb();
            }
        }), (int)14, null);
    }

    @NotNull
    public final Status run$misk_clustering_dynamodb() {
        if (this.clusterWeightProvider.get() > 0) {
            this.updateOurselfInDynamo();
        }
        this.recordCurrentDynamoCluster$misk_clustering_dynamodb();
        return Status.OK;
    }

    private final void updateOurselfInDynamo() {
        Duration duration = (Duration)TimedKt.timed((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DynamoClusterWatcherTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                String self = DynamoClusterWatcherTask.access$getCluster$p(this.this$0).getSnapshot().getSelf().getName();
                DyClusterMember member = new DyClusterMember();
                member.setName(self);
                member.setUpdated_at(DynamoClusterWatcherTask.access$getClock$p(this.this$0).instant().toEpochMilli());
                String string = DynamoClusterWatcherTask.access$getPodName$p(this.this$0);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    member.setPod_name(it);
                }
                DynamoClusterWatcherTask.access$getTable$p(this.this$0).putItem((Object)member);
            }
        })).component1();
        logger.info((Function0)new Function0<Object>(duration){
            final /* synthetic */ Duration $duration;
            {
                this.$duration = $duration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Updated dynamodb with my information in " + this.$duration.toMillis() + "ms";
            }
        });
    }

    public final void recordCurrentDynamoCluster$misk_clustering_dynamodb() {
        Duration duration = (Duration)TimedKt.timed((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ DynamoClusterWatcherTask this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Set members = new LinkedHashSet<E>();
                long threshold = DynamoClusterWatcherTask.access$getClock$p(this.this$0).instant().minusSeconds(DynamoClusterWatcherTask.access$getDynamoClusterConfig$p(this.this$0).getStale_threshold_seconds()).toEpochMilli();
                ScanEnhancedRequest request = ScanEnhancedRequest.builder().consistentRead(Boolean.valueOf(true)).filterExpression(Expression.builder().expression("updated_at >= :threshold").expressionValues(MapsKt.mapOf((Pair)TuplesKt.to((Object)":threshold", (Object)AttributeValues.numberValue((Number)threshold)))).build()).build();
                Iterator<T> iterator = DynamoClusterWatcherTask.access$getTable$p(this.this$0).scan(request).stream().iterator();
                while (iterator.hasNext()) {
                    Page page = (Page)iterator.next();
                    for (DyClusterMember item : page.items()) {
                        String string = item.getName();
                        Intrinsics.checkNotNull((Object)string);
                        members.add(new Cluster.Member(string, "invalid-ip"));
                    }
                }
                DynamoClusterWatcherTask.access$getCluster$p(this.this$0).clusterChanged(members, SetsKt.minus((Set)DynamoClusterWatcherTask.access$getPrevMembers$p(this.this$0), (Iterable)members));
                DynamoClusterWatcherTask.access$setPrevMembers$p(this.this$0, members);
            }
        })).component1();
        logger.info((Function0)new Function0<Object>(duration){
            final /* synthetic */ Duration $duration;
            {
                this.$duration = $duration;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Updated cluster information from dynamodb in " + this.$duration.toMillis() + "ms";
            }
        });
    }

    protected void shutDown() {
    }

    public static final /* synthetic */ DefaultCluster access$getCluster$p(DynamoClusterWatcherTask $this) {
        return $this.cluster;
    }

    public static final /* synthetic */ Clock access$getClock$p(DynamoClusterWatcherTask $this) {
        return $this.clock;
    }

    public static final /* synthetic */ String access$getPodName$p(DynamoClusterWatcherTask $this) {
        return $this.podName;
    }

    public static final /* synthetic */ DynamoDbTable access$getTable$p(DynamoClusterWatcherTask $this) {
        return $this.table;
    }

    public static final /* synthetic */ DynamoClusterConfig access$getDynamoClusterConfig$p(DynamoClusterWatcherTask $this) {
        return $this.dynamoClusterConfig;
    }

    public static final /* synthetic */ Set access$getPrevMembers$p(DynamoClusterWatcherTask $this) {
        return $this.prevMembers;
    }

    public static final /* synthetic */ void access$setPrevMembers$p(DynamoClusterWatcherTask $this, Set set) {
        $this.prevMembers = set;
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(DynamoClusterWatcherTask.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmisk/clustering/dynamo/DynamoClusterWatcherTask$Companion;", "", "()V", "TABLE_SCHEMA", "Lsoftware/amazon/awssdk/enhanced/dynamodb/TableSchema;", "Lmisk/clustering/dynamo/DyClusterMember;", "kotlin.jvm.PlatformType", "getTABLE_SCHEMA$misk_clustering_dynamodb", "()Lsoftware/amazon/awssdk/enhanced/dynamodb/TableSchema;", "logger", "Lmu/KLogger;", "misk-clustering-dynamodb"})
    public static final class Companion {
        private Companion() {
        }

        public final TableSchema<DyClusterMember> getTABLE_SCHEMA$misk_clustering_dynamodb() {
            return TABLE_SCHEMA;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

