//[misk-aws-dynamodb](../../index.md)/[misk.dynamodb](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [DynamoDbService](-dynamo-db-service/index.md) | [jvm]<br>interface [DynamoDbService](-dynamo-db-service/index.md) : Service<br>Service that's running when DynamoDb is usable. Configure your service to depend on this service if it needs DynamoDb. |
| [DyTimestampedEntity](-dy-timestamped-entity/index.md) | [jvm]<br>interface [DyTimestampedEntity](-dy-timestamped-entity/index.md)<br>Interface for a timestamped entity. |
| [DyVersionedEntity](-dy-versioned-entity/index.md) | [jvm]<br>interface [DyVersionedEntity](-dy-versioned-entity/index.md)<br>This version field is used for optimistic locking. |
| [RealDynamoDbModule](-real-dynamo-db-module/index.md) | [jvm]<br>open class [RealDynamoDbModule](-real-dynamo-db-module/index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(clientConfig: ClientConfiguration = ClientConfiguration(), requiredTableTypes: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;) : KAbstractModule<br>Install this module to have access to an AmazonDynamoDB client. This can be used to create a DynamoDbMapper for querying of a DynamoDb table. |
| [RealDynamoDbService](-real-dynamo-db-service/index.md) | [jvm]<br>@Singleton<br>class [RealDynamoDbService](-real-dynamo-db-service/index.md)@Injectconstructor(dynamoDb: AmazonDynamoDB, requiredTables: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[RequiredDynamoDbTable](-required-dynamo-db-table/index.md)&gt;) : AbstractIdleService, [DynamoDbService](-dynamo-db-service/index.md) |
| [RequiredDynamoDbTable](-required-dynamo-db-table/index.md) | [jvm]<br>data class [RequiredDynamoDbTable](-required-dynamo-db-table/index.md)(val name: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html))<br>A table that must be available in the DynamoDB instance. If this table doesn't exist, the service will not start up. |
