//[misk-aws-dynamodb](../../../index.md)/[misk.dynamodb](../index.md)/[RealDynamoDbModule](index.md)

# RealDynamoDbModule

open class [RealDynamoDbModule](index.md)@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)constructor(clientConfig: ClientConfiguration = ClientConfiguration(), requiredTableTypes: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;) : KAbstractModule

Install this module to have access to an AmazonDynamoDB client. This can be used to create a DynamoDbMapper for querying of a DynamoDb table.

#### Parameters

jvm

| | |
|---|---|
| requiredTableTypes | a list of mapper classes annotated DynamoDBTable. |

## Constructors

| | |
|---|---|
| [RealDynamoDbModule](-real-dynamo-db-module.md) | [jvm]<br>@[JvmOverloads](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.jvm/-jvm-overloads/index.html)<br>constructor(clientConfig: ClientConfiguration = ClientConfiguration(), vararg requiredTableTypes: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;) |

## Functions

| Name | Summary |
|---|---|
| [configure](index.md#-1079151965%2FFunctions%2F1677110241) | [jvm]<br>override fun [configure](index.md#-1079151965%2FFunctions%2F1677110241)(builder: Binder) |
| [configureClient](configure-client.md) | [jvm]<br>open fun [configureClient](configure-client.md)(builder: AmazonDynamoDBClientBuilder) |
| [configureStreamsClient](configure-streams-client.md) | [jvm]<br>open fun [configureStreamsClient](configure-streams-client.md)(builder: AmazonDynamoDBStreamsClientBuilder) |
| [provideRequiredTables](provide-required-tables.md) | [jvm]<br>@Provides<br>@Singleton<br>fun [provideRequiredTables](provide-required-tables.md)(): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[RequiredDynamoDbTable](../-required-dynamo-db-table/index.md)&gt; |
| [providesAmazonDynamoDB](provides-amazon-dynamo-d-b.md) | [jvm]<br>@Provides<br>@Singleton<br>fun [providesAmazonDynamoDB](provides-amazon-dynamo-d-b.md)(awsRegion: AwsRegion, awsCredentialsProvider: AWSCredentialsProvider): AmazonDynamoDB |
| [providesAmazonDynamoDBStreams](provides-amazon-dynamo-d-b-streams.md) | [jvm]<br>@Provides<br>@Singleton<br>fun [providesAmazonDynamoDBStreams](provides-amazon-dynamo-d-b-streams.md)(awsRegion: AwsRegion, awsCredentialsProvider: AWSCredentialsProvider): AmazonDynamoDBStreams |
