/*
 * Decompiled with CFR 0.152.
 */
package misk.dynamodb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.google.common.util.concurrent.AbstractService;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import misk.ReadyService;
import misk.ServiceModule;
import misk.cloud.aws.AwsRegion;
import misk.dynamodb.DynamoDbHealthCheck;
import misk.dynamodb.DynamoDbService;
import misk.dynamodb.RequiredDynamoDbTable;
import misk.exceptions.dynamodb.DynamoDbExceptionMapperModule;
import misk.healthchecks.HealthCheck;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001bB-\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lmisk/dynamodb/RealDynamoDbModule;", "Lmisk/inject/KAbstractModule;", "clientConfig", "Lcom/amazonaws/ClientConfiguration;", "requiredTableTypes", "", "Lkotlin/reflect/KClass;", "(Lcom/amazonaws/ClientConfiguration;[Lkotlin/reflect/KClass;)V", "requiredTables", "", "Lmisk/dynamodb/RequiredDynamoDbTable;", "configure", "", "configureClient", "builder", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBClientBuilder;", "configureStreamsClient", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBStreamsClientBuilder;", "provideRequiredTables", "providesAmazonDynamoDB", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "awsRegion", "Lmisk/cloud/aws/AwsRegion;", "awsCredentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "providesAmazonDynamoDBStreams", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBStreams;", "RealDynamoDbService", "misk-aws-dynamodb"})
@SourceDebugExtension(value={"SMAP\nRealDynamoDbModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealDynamoDbModule.kt\nmisk/dynamodb/RealDynamoDbModule\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 6 ServiceModule.kt\nmisk/ServiceModuleKt\n+ 7 ServiceModule.kt\nmisk/ServiceModule\n*L\n1#1,90:1\n11335#2:91\n11670#2,2:92\n11672#2:97\n20#3:94\n288#4,2:95\n49#5,2:98\n49#5,2:100\n52#5,10:102\n45#5:112\n41#5,5:113\n155#6,2:118\n124#7,2:120\n*S KotlinDebug\n*F\n+ 1 RealDynamoDbModule.kt\nmisk/dynamodb/RealDynamoDbModule\n*L\n33#1:91\n33#1:92,2\n33#1:97\n34#1:94\n34#1:95,2\n40#1:98,2\n41#1:100,2\n42#1:102,10\n42#1:112\n43#1:113,5\n44#1:118,2\n44#1:120,2\n*E\n"})
public class RealDynamoDbModule
extends KAbstractModule {
    @NotNull
    private final ClientConfiguration clientConfig;
    @NotNull
    private final List<RequiredDynamoDbTable> requiredTables;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public RealDynamoDbModule(@NotNull ClientConfiguration clientConfig, KClass<?> ... requiredTableTypes) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        Intrinsics.checkNotNullParameter(requiredTableTypes, (String)"requiredTableTypes");
        this.clientConfig = clientConfig;
        KClass<?>[] kClassArray = requiredTableTypes;
        RealDynamoDbModule realDynamoDbModule = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            DynamoDBTable annotation;
            Object v0;
            void it;
            Collection collection;
            block3: {
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)it;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof DynamoDBTable)) continue;
                    v0 = element$iv$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((DynamoDBTable)((Annotation)((DynamoDBTable)v0)) == null) {
                throw new IllegalArgumentException("no @DynamoDBTable on " + (KClass)it);
            }
            collection.add(new RequiredDynamoDbTable(annotation.tableName()));
        }
        realDynamoDbModule.requiredTables = (List)destination$iv$iv;
    }

    public /* synthetic */ RealDynamoDbModule(ClientConfiguration clientConfiguration, KClass[] kClassArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clientConfiguration = new ClientConfiguration();
        }
        this(clientConfiguration, kClassArray);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AWSCredentialsProvider.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AwsRegion.class);
        this_$iv = this;
        KClass annotation$iv = null;
        boolean $i$f$multibind = false;
        KAbstractModule this_$iv$iv = this;
        boolean $i$f$newMultibinder = false;
        LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HealthCheck.class), annotation$iv).addBinding();
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"newMultibinder<T>(annotation).addBinding()");
        LinkedBindingBuilder $this$to$iv = linkedBindingBuilder;
        boolean $i$f$to = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(DynamoDbHealthCheck.class), (String)"to(T::class.java)");
        this_$iv = this;
        KAbstractModule this_$iv2 = this;
        boolean $i$f$bind = false;
        AnnotatedBindingBuilder annotatedBindingBuilder = KAbstractModule.access$binder((KAbstractModule)this_$iv2).bind(DynamoDbService.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotatedBindingBuilder, (String)"binder().bind(T::class.java)");
        $this$to$iv = (LinkedBindingBuilder)new KAbstractModule.KotlinAnnotatedBindingBuilder(annotatedBindingBuilder);
        $i$f$to = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(RealDynamoDbService.class), (String)"to(T::class.java)");
        KClass qualifier$iv = null;
        boolean $i$f$ServiceModule = false;
        ServiceModule $this$iv = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(DynamoDbService.class), qualifier$iv), null, null, 6, null);
        KClass qualifier$iv2 = null;
        boolean $i$f$enhancedBy = false;
        this.install((Module)$this$iv.enhancedBy(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(ReadyService.class), qualifier$iv2)));
        this.install((Module)new DynamoDbExceptionMapperModule());
    }

    @Provides
    @Singleton
    @NotNull
    public final List<RequiredDynamoDbTable> provideRequiredTables() {
        return this.requiredTables;
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDB providesAmazonDynamoDB(@NotNull AwsRegion awsRegion, @NotNull AWSCredentialsProvider awsCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        AmazonDynamoDBClientBuilder builder = (AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(awsRegion.getName())).withCredentials(awsCredentialsProvider)).withClientConfiguration(this.clientConfig);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.configureClient(builder);
        Object object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return (AmazonDynamoDB)object;
    }

    public void configureClient(@NotNull AmazonDynamoDBClientBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDBStreams providesAmazonDynamoDBStreams(@NotNull AwsRegion awsRegion, @NotNull AWSCredentialsProvider awsCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        AmazonDynamoDBStreamsClientBuilder builder = (AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withRegion(awsRegion.getName())).withCredentials(awsCredentialsProvider)).withClientConfiguration(this.clientConfig);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder");
        this.configureStreamsClient(builder);
        Object object = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"builder.build()");
        return (AmazonDynamoDBStreams)object;
    }

    public void configureStreamsClient(@NotNull AmazonDynamoDBStreamsClientBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
    }

    @JvmOverloads
    public RealDynamoDbModule(KClass<?> ... requiredTableTypes) {
        Intrinsics.checkNotNullParameter(requiredTableTypes, (String)"requiredTableTypes");
        this(null, requiredTableTypes, 1, null);
    }

    @Singleton
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\u0007"}, d2={"Lmisk/dynamodb/RealDynamoDbModule$RealDynamoDbService;", "Lcom/google/common/util/concurrent/AbstractService;", "Lmisk/dynamodb/DynamoDbService;", "()V", "doStart", "", "doStop", "misk-aws-dynamodb"})
    private static final class RealDynamoDbService
    extends AbstractService
    implements DynamoDbService {
        @Inject
        public RealDynamoDbService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

