package misk.dynamodb

import java.util.Date

/**
 * Interface for a timestamped entity.
 */
interface DyTimestampedEntity {

  /**
   * Use the below annotations on the implementations. This will automatically
   * set field to be when the entity is created. This will save the Date as a
   * Long (epoch milliseconds).
   *
   * @DynamoDBAttribute(attributeName = "created_at")
   * @DynamoDBAutoGeneratedTimestamp(strategy = DynamoDBAutoGenerateStrategy.CREATE)
   */
  var created_at: Date

  /**
   * Use the below annotations on the implementations. This will automatically
   * set field every time entity is saved. This will save the Date as a
   * Long (epoch milliseconds).
   *
   * @DynamoDBAttribute(attributeName = "updated_at")
   * @DynamoDBAutoGeneratedTimestamp(strategy = DynamoDBAutoGenerateStrategy.ALWAYS)
   */
  var updated_at: Date
}
