/*
 * Decompiled with CFR 0.152.
 */
package misk.aws.dynamodb.testing;

import app.cash.tempest.testing.JvmDynamoDbServer;
import app.cash.tempest.testing.TestDynamoDbServer;
import app.cash.tempest.testing.TestTable;
import app.cash.tempest.testing.internal.TestDynamoDbService;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.google.common.util.concurrent.AbstractService;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import misk.ServiceModule;
import misk.aws.dynamodb.testing.DynamoDbTable;
import misk.aws.dynamodb.testing.TestDynamoDb;
import misk.dynamodb.DynamoDbHealthCheck;
import misk.dynamodb.DynamoDbService;
import misk.dynamodb.RequiredDynamoDbTable;
import misk.healthchecks.HealthCheck;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u001b\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B#\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0003\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0014J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\b\u0010\u0014\u001a\u00020\u0011H\u0007R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lmisk/aws/dynamodb/testing/InProcessDynamoDbModule;", "Lmisk/inject/KAbstractModule;", "tables", "", "Lmisk/aws/dynamodb/testing/DynamoDbTable;", "([Lmisk/aws/dynamodb/testing/DynamoDbTable;)V", "Lkotlin/reflect/KClass;", "([Lkotlin/reflect/KClass;)V", "", "(Ljava/util/List;)V", "configure", "", "provideRequiredTables", "Lmisk/dynamodb/RequiredDynamoDbTable;", "providesAmazonDynamoDB", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "testDynamoDb", "Lmisk/aws/dynamodb/testing/TestDynamoDb;", "providesAmazonDynamoDBStreams", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBStreams;", "providesDynamoDbServiceWrapper", "InProcessDynamoDbService", "misk-aws-dynamodb_testFixtures"})
@SourceDebugExtension(value={"SMAP\nInProcessDynamoDbModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InProcessDynamoDbModule.kt\nmisk/aws/dynamodb/testing/InProcessDynamoDbModule\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KAbstractModule.kt\nmisk/inject/KAbstractModule\n+ 4 ServiceModule.kt\nmisk/ServiceModuleKt\n+ 5 ServiceModule.kt\nmisk/ServiceModule\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n11335#2:79\n11670#2,3:80\n52#3,10:83\n52#3,10:93\n45#3:103\n41#3,5:104\n162#4,2:109\n162#4,2:113\n125#5,2:111\n1549#6:115\n1620#6,3:116\n1549#6:119\n1620#6,3:120\n*S KotlinDebug\n*F\n+ 1 InProcessDynamoDbModule.kt\nmisk/aws/dynamodb/testing/InProcessDynamoDbModule\n*L\n33#1:79\n33#1:80,3\n37#1:83,10\n39#1:93,10\n39#1:103\n40#1:104,5\n41#1:109,2\n42#1:113,2\n41#1:111,2\n50#1:115\n50#1:116,3\n68#1:119\n68#1:120,3\n*E\n"})
public final class InProcessDynamoDbModule
extends KAbstractModule {
    @NotNull
    private final List<DynamoDbTable> tables;

    public InProcessDynamoDbModule(@NotNull List<DynamoDbTable> tables) {
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        this.tables = tables;
    }

    public InProcessDynamoDbModule(DynamoDbTable ... tables) {
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        this(ArraysKt.toList((Object[])tables));
    }

    /*
     * WARNING - void declaration
     */
    public InProcessDynamoDbModule(KClass<?> ... tables) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(tables, (String)"tables");
        KClass<?>[] kClassArray = tables;
        InProcessDynamoDbModule inProcessDynamoDbModule = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DynamoDbTable((KClass)it, null, 2, null));
        }
        inProcessDynamoDbModule((List)destination$iv$iv);
    }

    protected void configure() {
        for (DynamoDbTable table : this.tables) {
            KClass annotation$iv = null;
            boolean $i$f$multibind = false;
            KAbstractModule this_$iv$iv = this;
            boolean $i$f$newMultibinder = false;
            LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(DynamoDbTable.class), annotation$iv).addBinding();
            Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"newMultibinder<T>(annotation).addBinding()");
            linkedBindingBuilder.toInstance((Object)table);
        }
        KAbstractModule kAbstractModule = this;
        KClass annotation$iv = null;
        boolean $i$f$multibind = false;
        KAbstractModule this_$iv$iv = this;
        boolean $i$f$newMultibinder = false;
        LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HealthCheck.class), annotation$iv).addBinding();
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"newMultibinder<T>(annotation).addBinding()");
        LinkedBindingBuilder $this$to$iv = linkedBindingBuilder;
        boolean $i$f$to = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(DynamoDbHealthCheck.class), (String)"to(T::class.java)");
        KAbstractModule this_$iv = this;
        KAbstractModule this_$iv2 = this;
        boolean $i$f$bind = false;
        AnnotatedBindingBuilder annotatedBindingBuilder = KAbstractModule.access$binder((KAbstractModule)this_$iv2).bind(DynamoDbService.class);
        Intrinsics.checkNotNullExpressionValue((Object)annotatedBindingBuilder, (String)"binder().bind(T::class.java)");
        $this$to$iv = (LinkedBindingBuilder)new KAbstractModule.KotlinAnnotatedBindingBuilder(annotatedBindingBuilder);
        $i$f$to = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$to$iv.to(InProcessDynamoDbService.class), (String)"to(T::class.java)");
        KClass qualifier$iv = null;
        boolean $i$f$ServiceModule = false;
        ServiceModule $this$iv = new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(DynamoDbService.class), qualifier$iv), null, null, 6, null);
        KClass qualifier$iv2 = null;
        boolean $i$f$dependsOn = false;
        this.install((Module)$this$iv.dependsOn(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(TestDynamoDb.class), qualifier$iv2)));
        qualifier$iv = null;
        $i$f$ServiceModule = false;
        this.install((Module)new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(TestDynamoDb.class), qualifier$iv), null, null, 6, null));
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final TestDynamoDb providesDynamoDbServiceWrapper() {
        Collection<TestTable> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.tables;
        TestDynamoDbServer.Factory factory = (TestDynamoDbServer.Factory)JvmDynamoDbServer.Factory.INSTANCE;
        TestDynamoDbService.Companion companion = TestDynamoDbService.Companion;
        boolean $i$f$map = false;
        void var3_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DynamoDbTable dynamoDbTable = (DynamoDbTable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TestTable.Companion.create(it.getTableClass(), it.getConfigureTable()));
        }
        collection = (List)destination$iv$iv;
        TestDynamoDbService testDynamoDbService = companion.create(factory, (List)collection, null);
        return new TestDynamoDb(testDynamoDbService);
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDB providesAmazonDynamoDB(@NotNull TestDynamoDb testDynamoDb) {
        Intrinsics.checkNotNullParameter((Object)testDynamoDb, (String)"testDynamoDb");
        return testDynamoDb.getService().getClient().getDynamoDb();
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDBStreams providesAmazonDynamoDBStreams(@NotNull TestDynamoDb testDynamoDb) {
        Intrinsics.checkNotNullParameter((Object)testDynamoDb, (String)"testDynamoDb");
        return testDynamoDb.getService().getClient().getDynamoDbStreams();
    }

    /*
     * WARNING - void declaration
     */
    @Provides
    @Singleton
    @NotNull
    public final List<RequiredDynamoDbTable> provideRequiredTables() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.tables;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DynamoDbTable dynamoDbTable = (DynamoDbTable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RequiredDynamoDbTable(it.getTableName()));
        }
        return (List)destination$iv$iv;
    }

    @Singleton
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\u0007"}, d2={"Lmisk/aws/dynamodb/testing/InProcessDynamoDbModule$InProcessDynamoDbService;", "Lcom/google/common/util/concurrent/AbstractService;", "Lmisk/dynamodb/DynamoDbService;", "()V", "doStart", "", "doStop", "misk-aws-dynamodb_testFixtures"})
    private static final class InProcessDynamoDbService
    extends AbstractService
    implements DynamoDbService {
        @Inject
        public InProcessDynamoDbService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

