/*
 * Decompiled with CFR 0.152.
 */
package misk.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import misk.dynamodb.RequiredDynamoDbTable;
import misk.healthchecks.HealthCheck;
import misk.healthchecks.HealthStatus;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmisk/dynamodb/DynamoDbHealthCheck;", "Lmisk/healthchecks/HealthCheck;", "dynamoDb", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "requiredTables", "", "Lmisk/dynamodb/RequiredDynamoDbTable;", "(Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;Ljava/util/List;)V", "status", "Lmisk/healthchecks/HealthStatus;", "Companion", "misk-aws-dynamodb"})
public final class DynamoDbHealthCheck
implements HealthCheck {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AmazonDynamoDB dynamoDb;
    @NotNull
    private final List<RequiredDynamoDbTable> requiredTables;
    @NotNull
    private static final KLogger logger;

    @Inject
    public DynamoDbHealthCheck(@NotNull AmazonDynamoDB dynamoDb, @NotNull List<RequiredDynamoDbTable> requiredTables) {
        Intrinsics.checkNotNullParameter((Object)dynamoDb, (String)"dynamoDb");
        Intrinsics.checkNotNullParameter(requiredTables, (String)"requiredTables");
        this.dynamoDb = dynamoDb;
        this.requiredTables = requiredTables;
    }

    @NotNull
    public HealthStatus status() {
        for (RequiredDynamoDbTable table : this.requiredTables) {
            try {
                this.dynamoDb.describeTable(table.getName());
            }
            catch (Exception e) {
                logger.error((Throwable)e, (Function0)new Function0<Object>(table){
                    final /* synthetic */ RequiredDynamoDbTable $table;
                    {
                        this.$table = $table;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "error performing DynamoDB health check for " + this.$table.getName();
                    }
                });
                String[] stringArray = new String[]{"DynamoDB: failed to describe " + table.getName()};
                return HealthStatus.Companion.unhealthy(stringArray);
            }
        }
        String[] stringArray = new String[]{"DynamoDB"};
        return HealthStatus.Companion.healthy(stringArray);
    }

    static {
        boolean $i$f$getLogger = false;
        String string = Reflection.getOrCreateKotlinClass(DynamoDbHealthCheck.class).getQualifiedName();
        Intrinsics.checkNotNull((Object)string);
        logger = KotlinLogging.INSTANCE.logger(string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lmisk/dynamodb/DynamoDbHealthCheck$Companion;", "", "()V", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "misk-aws-dynamodb"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KLogger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

