/*
 * Decompiled with CFR 0.152.
 */
package misk.dynamodb;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreams;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBStreamsClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.google.common.util.concurrent.AbstractService;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KClass;
import misk.ServiceModule;
import misk.cloud.aws.AwsRegion;
import misk.dynamodb.DynamoDbHealthCheck;
import misk.dynamodb.DynamoDbService;
import misk.dynamodb.RequiredDynamoDbTable;
import misk.exceptions.dynamodb.DynamoDbExceptionMapperModule;
import misk.healthchecks.HealthCheck;
import misk.inject.GuiceKt;
import misk.inject.KAbstractModule;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0014J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lmisk/dynamodb/RealDynamoDbModule;", "Lmisk/inject/KAbstractModule;", "clientConfig", "Lcom/amazonaws/ClientConfiguration;", "requiredTableTypes", "", "Lkotlin/reflect/KClass;", "(Lcom/amazonaws/ClientConfiguration;[Lkotlin/reflect/KClass;)V", "requiredTables", "", "Lmisk/dynamodb/RequiredDynamoDbTable;", "configure", "", "provideRequiredTables", "providesAmazonDynamoDB", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDB;", "awsRegion", "Lmisk/cloud/aws/AwsRegion;", "awsCredentialsProvider", "Lcom/amazonaws/auth/AWSCredentialsProvider;", "providesAmazonDynamoDBStreams", "Lcom/amazonaws/services/dynamodbv2/AmazonDynamoDBStreams;", "RealDynamoDbService", "misk-aws-dynamodb"})
public final class RealDynamoDbModule
extends KAbstractModule {
    @NotNull
    private final ClientConfiguration clientConfig;
    @NotNull
    private final List<RequiredDynamoDbTable> requiredTables;

    /*
     * WARNING - void declaration
     */
    public RealDynamoDbModule(@NotNull ClientConfiguration clientConfig, KClass<?> ... requiredTableTypes) {
        Collection<RequiredDynamoDbTable> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)clientConfig, (String)"clientConfig");
        Intrinsics.checkNotNullParameter(requiredTableTypes, (String)"requiredTableTypes");
        this.clientConfig = clientConfig;
        KClass<?>[] kClassArray = requiredTableTypes;
        RealDynamoDbModule realDynamoDbModule = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var8_9 = $this$mapTo$iv$iv;
        int n = ((void)var8_9).length;
        for (int i = 0; i < n; ++i) {
            DynamoDBTable dynamoDBTable;
            Object v0;
            void it;
            block3: {
                void item$iv$iv;
                void var12_13 = item$iv$iv = var8_9[i];
                collection = destination$iv$iv;
                boolean bl = false;
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)it;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl2 = false;
                    if (!(it$iv instanceof DynamoDBTable)) continue;
                    v0 = element$iv$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((dynamoDBTable = (DynamoDBTable)((Annotation)((DynamoDBTable)v0))) == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"no @DynamoDBTable on ", (Object)it));
            }
            DynamoDBTable annotation = dynamoDBTable;
            RequiredDynamoDbTable requiredDynamoDbTable = new RequiredDynamoDbTable(annotation.tableName());
            collection.add(requiredDynamoDbTable);
        }
        collection = (List)destination$iv$iv;
        realDynamoDbModule.requiredTables = collection;
    }

    public /* synthetic */ RealDynamoDbModule(ClientConfiguration clientConfiguration, KClass[] kClassArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clientConfiguration = new ClientConfiguration();
        }
        this(clientConfiguration, kClassArray);
    }

    protected void configure() {
        KAbstractModule this_$iv = this;
        boolean $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AWSCredentialsProvider.class);
        this_$iv = this;
        $i$f$requireBinding = false;
        KAbstractModule.access$requireBinding((KAbstractModule)this_$iv, AwsRegion.class);
        this_$iv = this;
        KClass annotation$iv = null;
        boolean $i$f$multibind = false;
        KAbstractModule this_$iv$iv = this;
        boolean $i$f$newMultibinder = false;
        LinkedBindingBuilder linkedBindingBuilder = KAbstractModule.access$newMultibinder((KAbstractModule)this_$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(HealthCheck.class), annotation$iv).addBinding();
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"newMultibinder<T>(annotation).addBinding()");
        LinkedBindingBuilder $this$to$iv = linkedBindingBuilder;
        boolean $i$f$to = false;
        linkedBindingBuilder = $this$to$iv.to(DynamoDbHealthCheck.class);
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"to(T::class.java)");
        this_$iv = this;
        KAbstractModule this_$iv2 = this;
        boolean $i$f$bind = false;
        linkedBindingBuilder = KAbstractModule.access$binder((KAbstractModule)this_$iv2).bind(DynamoDbService.class);
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"binder().bind(T::class.java)");
        $this$to$iv = (LinkedBindingBuilder)new KAbstractModule.KotlinAnnotatedBindingBuilder((AnnotatedBindingBuilder)linkedBindingBuilder);
        $i$f$to = false;
        linkedBindingBuilder = $this$to$iv.to(RealDynamoDbService.class);
        Intrinsics.checkNotNullExpressionValue((Object)linkedBindingBuilder, (String)"to(T::class.java)");
        KClass qualifier$iv = null;
        boolean $i$f$ServiceModule = false;
        this.install((Module)new ServiceModule(GuiceKt.toKey((KClass)Reflection.getOrCreateKotlinClass(DynamoDbService.class), qualifier$iv), null, null, 6, null));
        this.install((Module)new DynamoDbExceptionMapperModule());
    }

    @Provides
    @Singleton
    @NotNull
    public final List<RequiredDynamoDbTable> provideRequiredTables() {
        return this.requiredTables;
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDB providesAmazonDynamoDB(@NotNull AwsRegion awsRegion, @NotNull AWSCredentialsProvider awsCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        Object object = ((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(awsRegion.getName())).withCredentials(awsCredentialsProvider)).withClientConfiguration(this.clientConfig)).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"standard()\n      .withRe\u2026entConfig)\n      .build()");
        return (AmazonDynamoDB)object;
    }

    @Provides
    @Singleton
    @NotNull
    public final AmazonDynamoDBStreams providesAmazonDynamoDBStreams(@NotNull AwsRegion awsRegion, @NotNull AWSCredentialsProvider awsCredentialsProvider) {
        Intrinsics.checkNotNullParameter((Object)awsRegion, (String)"awsRegion");
        Intrinsics.checkNotNullParameter((Object)awsCredentialsProvider, (String)"awsCredentialsProvider");
        Object object = ((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)((AmazonDynamoDBStreamsClientBuilder)AmazonDynamoDBStreamsClientBuilder.standard().withRegion(awsRegion.getName())).withCredentials(awsCredentialsProvider)).withClientConfiguration(this.clientConfig)).build();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"standard()\n      .withRe\u2026entConfig)\n      .build()");
        return (AmazonDynamoDBStreams)object;
    }

    @Singleton
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0014\u00a8\u0006\u0007"}, d2={"Lmisk/dynamodb/RealDynamoDbModule$RealDynamoDbService;", "Lcom/google/common/util/concurrent/AbstractService;", "Lmisk/dynamodb/DynamoDbService;", "()V", "doStart", "", "doStop", "misk-aws-dynamodb"})
    private static final class RealDynamoDbService
    extends AbstractService
    implements DynamoDbService {
        @Inject
        public RealDynamoDbService() {
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

