/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.loaders;

import dagger.internal.Binding;
import dagger.internal.Keys;
import dagger.internal.Linker;
import dagger.internal.StaticInjection;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import javax.inject.Inject;

public final class ReflectiveStaticInjection
extends StaticInjection {
    private final ClassLoader loader;
    private final Field[] fields;
    private Binding<?>[] bindings;

    private ReflectiveStaticInjection(ClassLoader loader, Field[] fields) {
        this.fields = fields;
        this.loader = loader;
    }

    @Override
    public void attach(Linker linker) {
        this.bindings = new Binding[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            Field field = this.fields[i];
            String key = Keys.get(field.getGenericType(), field.getAnnotations(), field);
            this.bindings[i] = linker.requestBinding(key, field, this.loader);
        }
    }

    @Override
    public void inject() {
        try {
            for (int f = 0; f < this.fields.length; ++f) {
                this.fields[f].set(null, this.bindings[f].get());
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static StaticInjection create(Class<?> injectedClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Field field : injectedClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(Inject.class)) continue;
            field.setAccessible(true);
            fields.add(field);
        }
        if (fields.isEmpty()) {
            throw new IllegalArgumentException("No static injections: " + injectedClass.getName());
        }
        return new ReflectiveStaticInjection(injectedClass.getClassLoader(), fields.toArray(new Field[fields.size()]));
    }
}

