/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.loaders;

import dagger.internal.Binding;
import dagger.internal.Keys;
import dagger.internal.Linker;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

public final class ReflectiveAtInjectBinding<T>
extends Binding<T> {
    private final Field[] fields;
    private final ClassLoader loader;
    private final Constructor<T> constructor;
    private final Class<?> supertype;
    private final String[] keys;
    private final Binding<?>[] fieldBindings;
    private final Binding<?>[] parameterBindings;
    private Binding<? super T> supertypeBinding;

    private ReflectiveAtInjectBinding(String provideKey, String membersKey, boolean singleton, Class<?> type, Field[] fields, Constructor<T> constructor, int parameterCount, Class<?> supertype, String[] keys) {
        super(provideKey, membersKey, singleton, type);
        this.constructor = constructor;
        this.fields = fields;
        this.supertype = supertype;
        this.keys = keys;
        this.parameterBindings = new Binding[parameterCount];
        this.fieldBindings = new Binding[fields.length];
        this.loader = type.getClassLoader();
    }

    @Override
    public void attach(Linker linker) {
        int i;
        int k = 0;
        for (i = 0; i < this.fields.length; ++i) {
            if (this.fieldBindings[i] == null) {
                this.fieldBindings[i] = linker.requestBinding(this.keys[k], this.fields[i], this.loader);
            }
            ++k;
        }
        if (this.constructor != null) {
            for (i = 0; i < this.parameterBindings.length; ++i) {
                if (this.parameterBindings[i] == null) {
                    this.parameterBindings[i] = linker.requestBinding(this.keys[k], this.constructor, this.loader);
                }
                ++k;
            }
        }
        if (this.supertype != null && this.supertypeBinding == null) {
            this.supertypeBinding = linker.requestBinding(this.keys[k], this.membersKey, this.loader, false, true);
        }
    }

    @Override
    public T get() {
        T result;
        if (this.constructor == null) {
            throw new UnsupportedOperationException();
        }
        Object[] args = new Object[this.parameterBindings.length];
        for (int i = 0; i < this.parameterBindings.length; ++i) {
            args[i] = this.parameterBindings[i].get();
        }
        try {
            result = this.constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        this.injectMembers(result);
        return result;
    }

    @Override
    public void injectMembers(T t) {
        try {
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].set(t, this.fieldBindings[i].get());
            }
            if (this.supertypeBinding != null) {
                this.supertypeBinding.injectMembers(t);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void getDependencies(Set<Binding<?>> get, Set<Binding<?>> injectMembers) {
        if (this.parameterBindings != null) {
            Collections.addAll(get, this.parameterBindings);
        }
        Collections.addAll(injectMembers, this.fieldBindings);
        if (this.supertypeBinding != null) {
            injectMembers.add(this.supertypeBinding);
        }
    }

    @Override
    public String toString() {
        return this.provideKey != null ? this.provideKey : this.membersKey;
    }

    public static <T> Binding<T> create(Class<T> type, boolean mustHaveInjections) {
        Class<T> supertype;
        int parameterCount;
        String provideKey;
        boolean singleton = type.isAnnotationPresent(Singleton.class);
        ArrayList<String> keys = new ArrayList<String>();
        ArrayList<AccessibleObject> injectedFields = new ArrayList<AccessibleObject>();
        for (Class<T> c = type; c != Object.class; c = c.getSuperclass()) {
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                if (!accessibleObject.isAnnotationPresent(Inject.class) || Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
                if ((((Field)accessibleObject).getModifiers() & 2) != 0) {
                    throw new IllegalStateException("Can't inject private field: " + accessibleObject);
                }
                ((Field)accessibleObject).setAccessible(true);
                injectedFields.add(accessibleObject);
                keys.add(Keys.get(((Field)accessibleObject).getGenericType(), accessibleObject.getAnnotations(), accessibleObject));
            }
        }
        AccessibleObject injectedConstructor = null;
        for (AccessibleObject accessibleObject : ReflectiveAtInjectBinding.getConstructorsForType(type)) {
            if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
            if (injectedConstructor != null) {
                throw new Binding.InvalidBindingException(type.getName(), "has too many injectable constructors");
            }
            injectedConstructor = accessibleObject;
        }
        if (injectedConstructor == null) {
            if (!injectedFields.isEmpty()) {
                try {
                    injectedConstructor = type.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ignored) {}
            } else if (mustHaveInjections) {
                throw new Binding.InvalidBindingException(type.getName(), "has no injectable members. Do you want to add an injectable constructor?");
            }
        }
        if (injectedConstructor != null) {
            if ((((Constructor)injectedConstructor).getModifiers() & 2) != 0) {
                throw new IllegalStateException("Can't inject private constructor: " + injectedConstructor);
            }
            provideKey = Keys.get(type);
            ((Constructor)injectedConstructor).setAccessible(true);
            Type[] types = ((Constructor)injectedConstructor).getGenericParameterTypes();
            parameterCount = types.length;
            if (parameterCount != 0) {
                Annotation[][] annotationArray = ((Constructor)injectedConstructor).getParameterAnnotations();
                for (int p = 0; p < types.length; ++p) {
                    keys.add(Keys.get(types[p], annotationArray[p], injectedConstructor));
                }
            }
        } else {
            provideKey = null;
            parameterCount = 0;
            if (singleton) {
                throw new IllegalArgumentException("No injectable constructor on @Singleton " + type.getName());
            }
        }
        if ((supertype = type.getSuperclass()) != null) {
            if (Keys.isPlatformType(supertype.getName())) {
                supertype = null;
            } else {
                keys.add(Keys.getMembersKey(supertype));
            }
        }
        String string = Keys.getMembersKey(type);
        return new ReflectiveAtInjectBinding<T>(provideKey, string, singleton, type, injectedFields.toArray(new Field[injectedFields.size()]), injectedConstructor, parameterCount, supertype, keys.toArray(new String[keys.size()]));
    }

    private static <T> Constructor<T>[] getConstructorsForType(Class<T> type) {
        return type.getDeclaredConstructors();
    }
}

