/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.squareup.javapoet.CodeBlock;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public final class GraphVizWriter
implements Closeable {
    private static final String INDENT = "  ";
    private final Writer out;
    private int indent = 0;
    private int nextName = 1;
    private final Map<String, String> generatedNames = new LinkedHashMap<String, String>();

    public GraphVizWriter(Writer out) {
        this.out = out;
    }

    public void beginGraph(String ... attributes) throws IOException {
        this.indent();
        String type = this.indent == 0 ? "digraph " : "subgraph ";
        String name = this.nextName(this.indent == 0 ? "G" : "cluster");
        this.out.write(type);
        this.out.write(name);
        this.out.write(" {\n");
        ++this.indent;
        this.attributes(attributes);
    }

    public void endGraph() throws IOException {
        --this.indent;
        this.indent();
        this.out.write("}\n");
    }

    public void node(String name, String ... attributes) throws IOException {
        name = this.nodeName(name);
        this.indent();
        this.out.write(name);
        this.inlineAttributes(attributes);
        this.out.write(";\n");
    }

    public void edge(String source, String target, String ... attributes) throws IOException {
        source = this.nodeName(source);
        target = this.nodeName(target);
        this.indent();
        this.out.write(source);
        this.out.write(" -> ");
        this.out.write(target);
        this.inlineAttributes(attributes);
        this.out.write(";\n");
    }

    public void nodeDefaults(String ... attributes) throws IOException {
        if (attributes.length == 0) {
            return;
        }
        this.indent();
        this.out.write("node");
        this.inlineAttributes(attributes);
        this.out.write(";\n");
    }

    public void edgeDefaults(String ... attributes) throws IOException {
        if (attributes.length == 0) {
            return;
        }
        this.indent();
        this.out.write("edge");
        this.inlineAttributes(attributes);
        this.out.write(";\n");
    }

    private void attributes(String[] attributes) throws IOException {
        if (attributes.length == 0) {
            return;
        }
        if (attributes.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < attributes.length; i += 2) {
            this.indent();
            this.out.write(attributes[i]);
            this.out.write(" = ");
            this.out.write(this.literal(attributes[i + 1]));
            this.out.write(";\n");
        }
    }

    private void inlineAttributes(String[] attributes) throws IOException {
        if (attributes.length == 0) {
            return;
        }
        if (attributes.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        this.out.write(" [");
        for (int i = 0; i < attributes.length; i += 2) {
            if (i != 0) {
                this.out.write(";");
            }
            this.out.write(attributes[i]);
            this.out.write("=");
            this.out.write(this.literal(attributes[i + 1]));
        }
        this.out.write("]");
    }

    private String nodeName(String name) throws IOException {
        if (name.matches("\\w+")) {
            return name;
        }
        String generatedName = this.generatedNames.get(name);
        if (generatedName != null) {
            return generatedName;
        }
        generatedName = this.nextName("n");
        this.generatedNames.put(name, generatedName);
        this.node(generatedName, "label", name);
        return generatedName;
    }

    private String literal(String raw) {
        if (raw.matches("\\w+")) {
            return raw;
        }
        return CodeBlock.builder().add("$S", raw).build().toString();
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indent; ++i) {
            this.out.write(INDENT);
        }
    }

    private String nextName(String prefix) {
        return prefix + this.nextName++;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

