/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.annotations.VisibleForTesting;
import dagger.internal.Binding;
import dagger.internal.Loader;
import dagger.internal.ModuleAdapter;
import dagger.internal.StaticInjection;
import dagger.internal.codegen.GraphAnalysisInjectBinding;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class GraphAnalysisLoader
extends Loader {
    private final ProcessingEnvironment processingEnv;

    public GraphAnalysisLoader(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Binding<?> getAtInjectBinding(String key, String className, ClassLoader classLoader, boolean mustHaveInjections) {
        TypeElement type = GraphAnalysisLoader.resolveType(this.processingEnv.getElementUtils(), className);
        if (type == null) {
            return null;
        }
        if (type.getKind() == ElementKind.INTERFACE) {
            return null;
        }
        return GraphAnalysisInjectBinding.create(type, mustHaveInjections);
    }

    @VisibleForTesting
    static TypeElement resolveType(Elements elements, String className) {
        int index = GraphAnalysisLoader.nextDollar(className, className, 0);
        if (index == -1) {
            return GraphAnalysisLoader.getTypeElement(elements, className);
        }
        StringBuilder sb = new StringBuilder(className);
        return GraphAnalysisLoader.resolveType(elements, className, sb, index);
    }

    private static TypeElement resolveType(Elements elements, String className, StringBuilder sb, int index) {
        TypeElement type;
        sb.setCharAt(index, '.');
        int nextIndex = GraphAnalysisLoader.nextDollar(className, sb, index + 1);
        TypeElement typeElement = type = nextIndex == -1 ? GraphAnalysisLoader.getTypeElement(elements, sb) : GraphAnalysisLoader.resolveType(elements, className, sb, nextIndex);
        if (type != null) {
            return type;
        }
        sb.setCharAt(index, '$');
        nextIndex = GraphAnalysisLoader.nextDollar(className, sb, index + 1);
        return nextIndex == -1 ? GraphAnalysisLoader.getTypeElement(elements, sb) : GraphAnalysisLoader.resolveType(elements, className, sb, nextIndex);
    }

    private static int nextDollar(String className, CharSequence current, int searchStart) {
        int index;
        while (true) {
            if ((index = className.indexOf(36, searchStart)) == -1) {
                return -1;
            }
            if (index != 0 && index != className.length() - 1 && current.charAt(index - 1) != '.' && current.charAt(index + 1) != '.') break;
            searchStart = index + 1;
        }
        return index;
    }

    private static TypeElement getTypeElement(Elements elements, CharSequence className) {
        try {
            return elements.getTypeElement(className);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public <T> ModuleAdapter<T> getModuleAdapter(Class<T> moduleClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StaticInjection getStaticInjection(Class<?> injectedClass) {
        throw new UnsupportedOperationException();
    }
}

