/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Binding;
import dagger.internal.BindingsGroup;
import dagger.internal.Linker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class SetBinding<T>
extends Binding<Set<T>> {
    private final SetBinding<T> parent;
    private final List<Binding<?>> contributors;

    public static <T> void add(BindingsGroup bindings, String setKey, Binding<?> binding) {
        SetBinding.prepareSetBinding((BindingsGroup)bindings, (String)setKey, binding).contributors.add(Linker.scope(binding));
    }

    private static <T> SetBinding<T> prepareSetBinding(BindingsGroup bindings, String setKey, Binding<?> binding) {
        Binding<?> previous = bindings.get(setKey);
        if (previous instanceof SetBinding) {
            SetBinding setBinding;
            setBinding.setLibrary((setBinding = (SetBinding)previous).library() && binding.library());
            return setBinding;
        }
        if (previous != null) {
            throw new IllegalArgumentException("Duplicate:\n    " + previous + "\n    " + binding);
        }
        SetBinding<T> setBinding = new SetBinding<T>(setKey, binding.requiredBy);
        setBinding.setLibrary(binding.library());
        bindings.contributeSetBinding(setKey, setBinding);
        return (SetBinding)bindings.get(setKey);
    }

    public SetBinding(String key, Object requiredBy) {
        super(key, null, false, requiredBy);
        this.parent = null;
        this.contributors = new ArrayList();
    }

    public SetBinding(SetBinding<T> original) {
        super(original.provideKey, null, false, original.requiredBy);
        this.parent = original;
        this.setLibrary(original.library());
        this.setDependedOn(original.dependedOn());
        this.contributors = new ArrayList();
    }

    @Override
    public void attach(Linker linker) {
        for (Binding<?> contributor : this.contributors) {
            contributor.attach(linker);
        }
    }

    public int size() {
        int size = 0;
        SetBinding<T> binding = this;
        while (binding != null) {
            size += binding.contributors.size();
            binding = binding.parent;
        }
        return size;
    }

    @Override
    public Set<T> get() {
        ArrayList result = new ArrayList();
        SetBinding<T> setBinding = this;
        while (setBinding != null) {
            int size = setBinding.contributors.size();
            for (int i = 0; i < size; ++i) {
                Binding<?> contributor = setBinding.contributors.get(i);
                Object contribution = contributor.get();
                if (contributor.provideKey.equals(this.provideKey)) {
                    result.addAll((Set)contribution);
                    continue;
                }
                result.add(contribution);
            }
            setBinding = setBinding.parent;
        }
        return Collections.unmodifiableSet(new LinkedHashSet(result));
    }

    @Override
    public void getDependencies(Set<Binding<?>> getBindings, Set<Binding<?>> injectMembersBindings) {
        SetBinding<T> binding = this;
        while (binding != null) {
            getBindings.addAll(binding.contributors);
            binding = binding.parent;
        }
    }

    @Override
    public void injectMembers(Set<T> t) {
        throw new UnsupportedOperationException("Cannot inject members on a contributed Set<T>.");
    }

    @Override
    public String toString() {
        boolean first = true;
        StringBuilder builder = new StringBuilder("SetBinding[");
        SetBinding<T> setBinding = this;
        while (setBinding != null) {
            int size = setBinding.contributors.size();
            for (int i = 0; i < size; ++i) {
                if (!first) {
                    builder.append(",");
                }
                builder.append(setBinding.contributors.get(i));
                first = false;
            }
            setBinding = setBinding.parent;
        }
        builder.append("]");
        return builder.toString();
    }
}

