/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Binding;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ProblemDetector {
    public void detectCircularDependencies(Collection<Binding<?>> bindings) {
        ProblemDetector.detectCircularDependencies(bindings, new ArrayList());
    }

    public void detectUnusedBinding(Collection<Binding<?>> bindings) {
        ArrayList unusedBindings = new ArrayList();
        for (Binding<?> binding : bindings) {
            if (binding.library() || binding.dependedOn()) continue;
            unusedBindings.add(binding);
        }
        if (!unusedBindings.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("You have these unused @Provider methods:");
            for (int i = 0; i < unusedBindings.size(); ++i) {
                builder.append("\n    ").append(i + 1).append(". ").append(((Binding)unusedBindings.get((int)i)).requiredBy);
            }
            builder.append("\n    Set library=true in your module to disable this check.");
            throw new IllegalStateException(builder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void detectCircularDependencies(Collection<Binding<?>> bindings, List<Binding<?>> path) {
        for (Binding<?> binding : bindings) {
            if (binding.isCycleFree()) continue;
            if (binding.isVisiting()) {
                int index = path.indexOf(binding);
                StringBuilder message = new StringBuilder().append("Dependency cycle:");
                for (int i = index; i < path.size(); ++i) {
                    message.append("\n    ").append(i - index).append(". ").append(path.get((int)i).provideKey).append(" bound by ").append(path.get(i));
                }
                message.append("\n    ").append(0).append(". ").append(binding.provideKey);
                throw new IllegalStateException(message.toString());
            }
            binding.setVisiting(true);
            path.add(binding);
            try {
                ArraySet dependencies = new ArraySet();
                binding.getDependencies(dependencies, dependencies);
                ProblemDetector.detectCircularDependencies(dependencies, path);
                binding.setCycleFree(true);
            }
            finally {
                path.remove(path.size() - 1);
                binding.setVisiting(false);
            }
        }
    }

    public void detectProblems(Collection<Binding<?>> values) {
        this.detectCircularDependencies(values);
        this.detectUnusedBinding(values);
    }

    static class ArraySet<T>
    extends AbstractSet<T> {
        private final ArrayList<T> list = new ArrayList();

        ArraySet() {
        }

        @Override
        public boolean add(T t) {
            this.list.add(t);
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }
    }
}

