/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Loader;
import dagger.internal.ModuleAdapter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Modules {
    private Modules() {
    }

    public static Map<ModuleAdapter<?>, Object> loadModules(Loader loader, Object[] seedModulesOrClasses) {
        LinkedHashMap<ModuleAdapter<Object>, Object> seedAdapters = new LinkedHashMap<ModuleAdapter<Object>, Object>(seedModulesOrClasses.length);
        for (int i = 0; i < seedModulesOrClasses.length; ++i) {
            ModuleAdapter<Object> adapter;
            if (seedModulesOrClasses[i] instanceof Class) {
                adapter = loader.getModuleAdapter((Class)seedModulesOrClasses[i]);
                seedAdapters.put(adapter, adapter.newModule());
                continue;
            }
            adapter = loader.getModuleAdapter(seedModulesOrClasses[i].getClass());
            seedAdapters.put(adapter, seedModulesOrClasses[i]);
        }
        LinkedHashMap result = new LinkedHashMap(seedAdapters);
        LinkedHashMap transitiveInclusions = new LinkedHashMap();
        for (ModuleAdapter adapter : seedAdapters.keySet()) {
            Modules.collectIncludedModulesRecursively(loader, adapter, transitiveInclusions);
        }
        for (ModuleAdapter dependency : transitiveInclusions.values()) {
            if (result.containsKey(dependency)) continue;
            result.put(dependency, dependency.newModule());
        }
        return result;
    }

    private static void collectIncludedModulesRecursively(Loader plugin, ModuleAdapter<?> adapter, Map<Class<?>, ModuleAdapter<?>> result) {
        for (Class<?> include : adapter.includes) {
            if (result.containsKey(include)) continue;
            ModuleAdapter<?> includedModuleAdapter = plugin.getModuleAdapter(include);
            result.put(include, includedModuleAdapter);
            Modules.collectIncludedModulesRecursively(plugin, includedModuleAdapter, result);
        }
    }
}

