/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

abstract class Memoizer<K, V> {
    private final Map<K, V> map = new LinkedHashMap();
    private final Lock readLock;
    private final Lock writeLock;

    public Memoizer() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.readLock.lock();
        try {
            V value = this.map.get(key);
            if (value != null) {
                V v = value;
                return v;
            }
        }
        finally {
            this.readLock.unlock();
        }
        V newValue = this.create(key);
        if (newValue == null) {
            throw new NullPointerException("create returned null");
        }
        this.writeLock.lock();
        try {
            this.map.put(key, newValue);
            V v = newValue;
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected abstract V create(K var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toString() {
        this.readLock.lock();
        try {
            String string = this.map.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

