/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Binding;
import dagger.internal.Memoizer;
import dagger.internal.ModuleAdapter;
import dagger.internal.StaticInjection;

public abstract class Loader {
    private final Memoizer<ClassLoader, Memoizer<String, Class<?>>> caches = new Memoizer<ClassLoader, Memoizer<String, Class<?>>>(){

        @Override
        protected Memoizer<String, Class<?>> create(final ClassLoader classLoader) {
            return new Memoizer<String, Class<?>>(){

                @Override
                protected Class<?> create(String className) {
                    try {
                        return classLoader.loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        return Void.class;
                    }
                }
            };
        }
    };

    public abstract Binding<?> getAtInjectBinding(String var1, String var2, ClassLoader var3, boolean var4);

    public abstract <T> ModuleAdapter<T> getModuleAdapter(Class<T> var1);

    public abstract StaticInjection getStaticInjection(Class<?> var1);

    protected Class<?> loadClass(ClassLoader classLoader, String name) {
        classLoader = classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
        return this.caches.get(classLoader).get(name);
    }

    protected <T> T instantiate(String name, ClassLoader classLoader) {
        try {
            Class<?> generatedClass = this.loadClass(classLoader, name);
            if (generatedClass == Void.class) {
                return null;
            }
            Object instance = generatedClass.newInstance();
            return (T)instance;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to initialize " + name, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to initialize " + name, e);
        }
    }
}

