/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.ArrayQueue;
import dagger.internal.Binding;
import dagger.internal.BindingsGroup;
import dagger.internal.BuiltInBinding;
import dagger.internal.Keys;
import dagger.internal.LazyBinding;
import dagger.internal.Loader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class Linker {
    static final Object UNINITIALIZED = new Object();
    private final Linker base;
    private final Queue<Binding<?>> toLink = new ArrayQueue();
    private boolean attachSuccess = true;
    private final List<String> errors = new ArrayList<String>();
    private final Map<String, Binding<?>> bindings = new HashMap();
    private volatile Map<String, Binding<?>> linkedBindings = null;
    private final Loader plugin;
    private final ErrorHandler errorHandler;

    public Linker(Linker base, Loader plugin, ErrorHandler errorHandler) {
        if (plugin == null) {
            throw new NullPointerException("plugin");
        }
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler");
        }
        this.base = base;
        this.plugin = plugin;
        this.errorHandler = errorHandler;
    }

    public void installBindings(BindingsGroup toInstall) {
        if (this.linkedBindings != null) {
            throw new IllegalStateException("Cannot install further bindings after calling linkAll().");
        }
        for (Map.Entry<String, Binding<?>> entry : toInstall.entrySet()) {
            this.bindings.put(entry.getKey(), Linker.scope(entry.getValue()));
        }
    }

    public Map<String, Binding<?>> linkAll() {
        this.assertLockHeld();
        if (this.linkedBindings != null) {
            return this.linkedBindings;
        }
        for (Binding<?> binding : this.bindings.values()) {
            if (binding.isLinked()) continue;
            this.toLink.add(binding);
        }
        this.linkRequested();
        this.linkedBindings = Collections.unmodifiableMap(this.bindings);
        return this.linkedBindings;
    }

    public Map<String, Binding<?>> fullyLinkedBindings() {
        return this.linkedBindings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkRequested() {
        Binding<?> binding;
        this.assertLockHeld();
        while ((binding = this.toLink.poll()) != null) {
            if (binding instanceof DeferredBinding) {
                DeferredBinding deferred = (DeferredBinding)binding;
                String key = deferred.deferredKey;
                boolean mustHaveInjections = deferred.mustHaveInjections;
                if (this.bindings.containsKey(key)) continue;
                try {
                    Binding<?> resolvedBinding = this.createBinding(key, binding.requiredBy, deferred.classLoader, mustHaveInjections);
                    resolvedBinding.setLibrary(binding.library());
                    resolvedBinding.setDependedOn(binding.dependedOn());
                    if (!key.equals(resolvedBinding.provideKey) && !key.equals(resolvedBinding.membersKey)) {
                        throw new IllegalStateException("Unable to create binding for " + key);
                    }
                    Binding<?> scopedBinding = Linker.scope(resolvedBinding);
                    this.toLink.add(scopedBinding);
                    this.putBinding(scopedBinding);
                    continue;
                }
                catch (Binding.InvalidBindingException e) {
                    this.addError(e.type + " " + e.getMessage() + " required by " + binding.requiredBy);
                    this.bindings.put(key, Binding.UNRESOLVED);
                    continue;
                }
                catch (UnsupportedOperationException e) {
                    this.addError("Unsupported: " + e.getMessage() + " required by " + binding.requiredBy);
                    this.bindings.put(key, Binding.UNRESOLVED);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    this.addError(e.getMessage() + " required by " + binding.requiredBy);
                    this.bindings.put(key, Binding.UNRESOLVED);
                    continue;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.attachSuccess = true;
            binding.attach(this);
            if (this.attachSuccess) {
                binding.setLinked();
                continue;
            }
            this.toLink.add(binding);
        }
        try {
            this.errorHandler.handleErrors(this.errors);
        }
        finally {
            this.errors.clear();
        }
    }

    private void assertLockHeld() {
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
    }

    private Binding<?> createBinding(String key, Object requiredBy, ClassLoader classLoader, boolean mustHaveInjections) {
        String builtInBindingsKey = Keys.getBuiltInBindingsKey(key);
        if (builtInBindingsKey != null) {
            return new BuiltInBinding(key, requiredBy, classLoader, builtInBindingsKey);
        }
        String lazyKey = Keys.getLazyKey(key);
        if (lazyKey != null) {
            return new LazyBinding(key, requiredBy, classLoader, lazyKey);
        }
        String className = Keys.getClassName(key);
        if (className == null) {
            throw new Binding.InvalidBindingException(key, "is a generic class or an array and can only be bound with concrete type parameter(s) in a @Provides method.");
        }
        if (Keys.isAnnotated(key)) {
            throw new Binding.InvalidBindingException(key, "is a @Qualifier-annotated type and must be bound by a @Provides method.");
        }
        Binding<?> binding = this.plugin.getAtInjectBinding(key, className, classLoader, mustHaveInjections);
        if (binding != null) {
            return binding;
        }
        throw new Binding.InvalidBindingException(className, "could not be bound with key " + key);
    }

    @Deprecated
    public Binding<?> requestBinding(String key, Object requiredBy) {
        return this.requestBinding(key, requiredBy, this.getClass().getClassLoader(), true, true);
    }

    public Binding<?> requestBinding(String key, Object requiredBy, ClassLoader classLoader) {
        return this.requestBinding(key, requiredBy, classLoader, true, true);
    }

    @Deprecated
    public Binding<?> requestBinding(String key, Object requiredBy, boolean mustHaveInjections, boolean library) {
        return this.requestBinding(key, requiredBy, this.getClass().getClassLoader(), mustHaveInjections, library);
    }

    public Binding<?> requestBinding(String key, Object requiredBy, ClassLoader classLoader, boolean mustHaveInjections, boolean library) {
        this.assertLockHeld();
        Binding<?> binding = null;
        Linker linker = this;
        while (linker != null) {
            binding = linker.bindings.get(key);
            if (binding != null) {
                if (linker != this && !binding.isLinked()) {
                    throw new AssertionError();
                }
                break;
            }
            linker = linker.base;
        }
        if (binding == null) {
            DeferredBinding deferredBinding = new DeferredBinding(key, classLoader, requiredBy, mustHaveInjections);
            deferredBinding.setLibrary(library);
            deferredBinding.setDependedOn(true);
            this.toLink.add(deferredBinding);
            this.attachSuccess = false;
            return null;
        }
        if (!binding.isLinked()) {
            this.toLink.add(binding);
        }
        binding.setLibrary(library);
        binding.setDependedOn(true);
        return binding;
    }

    private <T> void putBinding(Binding<T> binding) {
        if (binding.provideKey != null) {
            this.putIfAbsent(this.bindings, binding.provideKey, binding);
        }
        if (binding.membersKey != null) {
            this.putIfAbsent(this.bindings, binding.membersKey, binding);
        }
    }

    static <T> Binding<T> scope(Binding<T> binding) {
        if (!binding.isSingleton() || binding instanceof SingletonBinding) {
            return binding;
        }
        return new SingletonBinding<T>(binding);
    }

    private <K, V> void putIfAbsent(Map<K, V> map, K key, V value) {
        V replaced = map.put(key, value);
        if (replaced != null) {
            map.put(key, replaced);
        }
    }

    private void addError(String message) {
        this.errors.add(message);
    }

    private static class DeferredBinding
    extends Binding<Object> {
        final ClassLoader classLoader;
        final String deferredKey;
        final boolean mustHaveInjections;

        DeferredBinding(String deferredKey, ClassLoader classLoader, Object requiredBy, boolean mustHaveInjections) {
            super(null, null, false, requiredBy);
            this.deferredKey = deferredKey;
            this.classLoader = classLoader;
            this.mustHaveInjections = mustHaveInjections;
        }

        @Override
        public void injectMembers(Object t) {
            throw new UnsupportedOperationException("Deferred bindings must resolve first.");
        }

        @Override
        public void getDependencies(Set<Binding<?>> get, Set<Binding<?>> injectMembers) {
            throw new UnsupportedOperationException("Deferred bindings must resolve first.");
        }

        @Override
        public String toString() {
            return "DeferredBinding[deferredKey=" + this.deferredKey + "]";
        }
    }

    public static interface ErrorHandler {
        public static final ErrorHandler NULL = new ErrorHandler(){

            @Override
            public void handleErrors(List<String> errors) {
            }
        };

        public void handleErrors(List<String> var1);
    }

    private static class SingletonBinding<T>
    extends Binding<T> {
        private final Binding<T> binding;
        private volatile Object onlyInstance = UNINITIALIZED;

        SingletonBinding(Binding<T> binding) {
            super(binding.provideKey, binding.membersKey, true, binding.requiredBy);
            this.binding = binding;
        }

        @Override
        public void attach(Linker linker) {
            this.binding.attach(linker);
        }

        @Override
        public void injectMembers(T t) {
            this.binding.injectMembers(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.onlyInstance == UNINITIALIZED) {
                SingletonBinding singletonBinding = this;
                synchronized (singletonBinding) {
                    if (this.onlyInstance == UNINITIALIZED) {
                        this.onlyInstance = this.binding.get();
                    }
                }
            }
            return (T)this.onlyInstance;
        }

        @Override
        public void getDependencies(Set<Binding<?>> get, Set<Binding<?>> injectMembers) {
            this.binding.getDependencies(get, injectMembers);
        }

        @Override
        public boolean isCycleFree() {
            return this.binding.isCycleFree();
        }

        @Override
        public boolean isLinked() {
            return this.binding.isLinked();
        }

        @Override
        public boolean isVisiting() {
            return this.binding.isVisiting();
        }

        @Override
        public boolean library() {
            return this.binding.library();
        }

        @Override
        public boolean dependedOn() {
            return this.binding.dependedOn();
        }

        @Override
        public void setCycleFree(boolean cycleFree) {
            this.binding.setCycleFree(cycleFree);
        }

        @Override
        public void setVisiting(boolean visiting) {
            this.binding.setVisiting(visiting);
        }

        @Override
        public void setLibrary(boolean library) {
            this.binding.setLibrary(true);
        }

        @Override
        public void setDependedOn(boolean dependedOn) {
            this.binding.setDependedOn(dependedOn);
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        @Override
        protected void setLinked() {
            this.binding.setLinked();
        }

        @Override
        public String toString() {
            return "@Singleton/" + this.binding.toString();
        }
    }
}

