/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.internal.Binding;
import dagger.internal.Linker;

final class LazyBinding<T>
extends Binding<Lazy<T>> {
    static final Object NOT_PRESENT = new Object();
    private final String lazyKey;
    private final ClassLoader loader;
    Binding<T> delegate;

    LazyBinding(String key, Object requiredBy, ClassLoader loader, String lazyKey) {
        super(key, null, false, requiredBy);
        this.loader = loader;
        this.lazyKey = lazyKey;
    }

    @Override
    public void attach(Linker linker) {
        this.delegate = linker.requestBinding(this.lazyKey, this.requiredBy, this.loader);
    }

    @Override
    public void injectMembers(Lazy<T> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Lazy<T> get() {
        return new Lazy<T>(){
            private volatile Object cacheValue = NOT_PRESENT;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (this.cacheValue == NOT_PRESENT) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.cacheValue == NOT_PRESENT) {
                            this.cacheValue = LazyBinding.this.delegate.get();
                        }
                    }
                }
                return this.cacheValue;
            }
        };
    }
}

