/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.Lazy;
import dagger.MembersInjector;
import dagger.internal.Memoizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Provider;
import javax.inject.Qualifier;

public final class Keys {
    private static final String PROVIDER_PREFIX = Provider.class.getCanonicalName() + "<";
    private static final String MEMBERS_INJECTOR_PREFIX = MembersInjector.class.getCanonicalName() + "<";
    private static final String LAZY_PREFIX = Lazy.class.getCanonicalName() + "<";
    private static final String SET_PREFIX = Set.class.getCanonicalName() + "<";
    private static final Memoizer<Class<? extends Annotation>, Boolean> IS_QUALIFIER_ANNOTATION = new Memoizer<Class<? extends Annotation>, Boolean>(){

        @Override
        protected Boolean create(Class<? extends Annotation> annotationType) {
            return annotationType.isAnnotationPresent(Qualifier.class);
        }
    };

    Keys() {
    }

    public static String get(Type type) {
        return Keys.get(type, null);
    }

    public static String getMembersKey(Class<?> key) {
        return "members/".concat(key.getName());
    }

    private static String get(Type type, Annotation annotation) {
        type = Keys.boxIfPrimitive(type);
        if (annotation == null && type instanceof Class && !((Class)type).isArray()) {
            return ((Class)type).getName();
        }
        StringBuilder result = new StringBuilder();
        if (annotation != null) {
            result.append(annotation).append("/");
        }
        Keys.typeToString(type, result, true);
        return result.toString();
    }

    public static String getSetKey(Type type, Annotation[] annotations, Object subject) {
        Annotation qualifier = Keys.extractQualifier(annotations, subject);
        type = Keys.boxIfPrimitive(type);
        StringBuilder result = new StringBuilder();
        if (qualifier != null) {
            result.append(qualifier).append("/");
        }
        result.append(SET_PREFIX);
        Keys.typeToString(type, result, true);
        result.append(">");
        return result.toString();
    }

    public static String get(Type type, Annotation[] annotations, Object subject) {
        return Keys.get(type, Keys.extractQualifier(annotations, subject));
    }

    private static Annotation extractQualifier(Annotation[] annotations, Object subject) {
        Annotation qualifier = null;
        for (Annotation a : annotations) {
            if (!IS_QUALIFIER_ANNOTATION.get(a.annotationType()).booleanValue()) continue;
            if (qualifier != null) {
                throw new IllegalArgumentException("Too many qualifier annotations on " + subject);
            }
            qualifier = a;
        }
        return qualifier;
    }

    private static void typeToString(Type type, StringBuilder result, boolean topLevel) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                Keys.typeToString(c.getComponentType(), result, false);
                result.append("[]");
            } else if (c.isPrimitive()) {
                if (topLevel) {
                    throw new UnsupportedOperationException("Uninjectable type " + c.getName());
                }
                result.append(c.getName());
            } else {
                result.append(c.getName());
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Keys.typeToString(parameterizedType.getRawType(), result, true);
            Type[] arguments = parameterizedType.getActualTypeArguments();
            result.append("<");
            for (int i = 0; i < arguments.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                Keys.typeToString(arguments[i], result, true);
            }
            result.append(">");
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Keys.typeToString(genericArrayType.getGenericComponentType(), result, false);
            result.append("[]");
        } else {
            throw new UnsupportedOperationException("Uninjectable type " + type);
        }
    }

    static String getBuiltInBindingsKey(String key) {
        int start = Keys.startOfType(key);
        if (Keys.substringStartsWith(key, start, PROVIDER_PREFIX)) {
            return Keys.extractKey(key, start, key.substring(0, start), PROVIDER_PREFIX);
        }
        if (Keys.substringStartsWith(key, start, MEMBERS_INJECTOR_PREFIX)) {
            return Keys.extractKey(key, start, "members/", MEMBERS_INJECTOR_PREFIX);
        }
        return null;
    }

    static String getLazyKey(String key) {
        int start = Keys.startOfType(key);
        if (Keys.substringStartsWith(key, start, LAZY_PREFIX)) {
            return Keys.extractKey(key, start, key.substring(0, start), LAZY_PREFIX);
        }
        return null;
    }

    private static int startOfType(String key) {
        return key.startsWith("@") ? key.lastIndexOf(47) + 1 : 0;
    }

    private static String extractKey(String key, int start, String delegatePrefix, String prefix) {
        return delegatePrefix + key.substring(start + prefix.length(), key.length() - 1);
    }

    private static boolean substringStartsWith(String string, int offset, String substring) {
        return string.regionMatches(offset, substring, 0, substring.length());
    }

    public static boolean isAnnotated(String key) {
        return key.startsWith("@");
    }

    public static String getClassName(String key) {
        int start = 0;
        if (key.startsWith("@") || key.startsWith("members/")) {
            start = key.lastIndexOf(47) + 1;
        }
        return key.indexOf(60, start) == -1 && key.indexOf(91, start) == -1 ? key.substring(start) : null;
    }

    public static boolean isPlatformType(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.");
    }

    private static Type boxIfPrimitive(Type type) {
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Void.TYPE) {
            return Void.class;
        }
        return type;
    }
}

