/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Binding;
import dagger.internal.Loader;
import dagger.internal.Memoizer;
import dagger.internal.ModuleAdapter;
import dagger.internal.StaticInjection;
import dagger.internal.loaders.ReflectiveAtInjectBinding;
import dagger.internal.loaders.ReflectiveStaticInjection;

public final class FailoverLoader
extends Loader {
    private final Memoizer<Class<?>, ModuleAdapter<?>> loadedAdapters = new Memoizer<Class<?>, ModuleAdapter<?>>(){

        @Override
        protected ModuleAdapter<?> create(Class<?> type) {
            ModuleAdapter result = (ModuleAdapter)FailoverLoader.this.instantiate(type.getName().concat("$$ModuleAdapter"), type.getClassLoader());
            if (result == null) {
                throw new IllegalStateException("Module adapter for " + type + " could not be loaded. " + "Please ensure that code generation was run for this module.");
            }
            return result;
        }
    };

    @Override
    public <T> ModuleAdapter<T> getModuleAdapter(Class<T> type) {
        return this.loadedAdapters.get(type);
    }

    @Override
    public Binding<?> getAtInjectBinding(String key, String className, ClassLoader classLoader, boolean mustHaveInjections) {
        Binding result = (Binding)this.instantiate(className.concat("$$InjectAdapter"), classLoader);
        if (result != null) {
            return result;
        }
        Class<?> type = this.loadClass(classLoader, className);
        if (type.equals(Void.class)) {
            throw new IllegalStateException(String.format("Could not load class %s needed for binding %s", className, key));
        }
        if (type.isInterface()) {
            return null;
        }
        return ReflectiveAtInjectBinding.create(type, mustHaveInjections);
    }

    @Override
    public StaticInjection getStaticInjection(Class<?> injectedClass) {
        StaticInjection result = (StaticInjection)this.instantiate(injectedClass.getName().concat("$$StaticInjection"), injectedClass.getClassLoader());
        if (result != null) {
            return result;
        }
        return ReflectiveStaticInjection.create(injectedClass);
    }
}

