/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.MembersInjector;
import dagger.internal.Keys;
import dagger.internal.Linker;
import java.util.Set;
import javax.inject.Provider;

public abstract class Binding<T>
implements Provider<T>,
MembersInjector<T> {
    public static final Binding<Object> UNRESOLVED = new Binding<Object>(null, null, false, null){

        @Override
        public Object get() {
            throw new AssertionError((Object)"Unresolved binding should never be called to inject.");
        }

        @Override
        public void injectMembers(Object t) {
            throw new AssertionError((Object)"Unresolved binding should never be called to inject.");
        }
    };
    protected static final boolean IS_SINGLETON = true;
    protected static final boolean NOT_SINGLETON = false;
    private static final int SINGLETON = 1;
    private static final int LINKED = 2;
    private static final int VISITING = 4;
    private static final int CYCLE_FREE = 8;
    private static final int DEPENDED_ON = 16;
    private static final int LIBRARY = 32;
    public final String provideKey;
    public final String membersKey;
    private int bits;
    public final Object requiredBy;

    protected Binding(String provideKey, String membersKey, boolean singleton, Object requiredBy) {
        if (singleton && provideKey == null) {
            throw new InvalidBindingException(Keys.getClassName(membersKey), "is exclusively members injected and therefore cannot be scoped");
        }
        this.provideKey = provideKey;
        this.membersKey = membersKey;
        this.requiredBy = requiredBy;
        this.bits = singleton ? 1 : 0;
    }

    public void attach(Linker linker) {
    }

    @Override
    public void injectMembers(T t) {
    }

    @Override
    public T get() {
        throw new UnsupportedOperationException("No injectable constructor on " + this.getClass().getName());
    }

    public void getDependencies(Set<Binding<?>> getBindings, Set<Binding<?>> injectMembersBindings) {
    }

    void setLinked() {
        this.bits |= 2;
    }

    public boolean isLinked() {
        return (this.bits & 2) != 0;
    }

    boolean isSingleton() {
        return (this.bits & 1) != 0;
    }

    public boolean isVisiting() {
        return (this.bits & 4) != 0;
    }

    public void setVisiting(boolean visiting) {
        this.bits = visiting ? this.bits | 4 : this.bits & 0xFFFFFFFB;
    }

    public boolean isCycleFree() {
        return (this.bits & 8) != 0;
    }

    public void setCycleFree(boolean cycleFree) {
        this.bits = cycleFree ? this.bits | 8 : this.bits & 0xFFFFFFF7;
    }

    public void setLibrary(boolean library) {
        this.bits = library ? this.bits | 0x20 : this.bits & 0xFFFFFFDF;
    }

    public boolean library() {
        return (this.bits & 0x20) != 0;
    }

    public void setDependedOn(boolean dependedOn) {
        this.bits = dependedOn ? this.bits | 0x10 : this.bits & 0xFFFFFFEF;
    }

    public boolean dependedOn() {
        return (this.bits & 0x10) != 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[provideKey=\"" + this.provideKey + "\", memberskey=\"" + this.membersKey + "\"]";
    }

    public static class InvalidBindingException
    extends RuntimeException {
        public final String type;

        public InvalidBindingException(String type, String error) {
            super(error);
            this.type = type;
        }
    }
}

