/*
 * Decompiled with CFR 0.152.
 */
package dagger;

import dagger.internal.Binding;
import dagger.internal.BindingsGroup;
import dagger.internal.FailoverLoader;
import dagger.internal.Keys;
import dagger.internal.Linker;
import dagger.internal.Loader;
import dagger.internal.ModuleAdapter;
import dagger.internal.Modules;
import dagger.internal.ProblemDetector;
import dagger.internal.SetBinding;
import dagger.internal.StaticInjection;
import dagger.internal.ThrowingErrorHandler;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class ObjectGraph {
    ObjectGraph() {
    }

    public abstract <T> T get(Class<T> var1);

    public abstract <T> T inject(T var1);

    public abstract ObjectGraph plus(Object ... var1);

    public abstract void validate();

    public abstract void injectStatics();

    public static ObjectGraph create(Object ... modules) {
        return DaggerObjectGraph.makeGraph(null, new FailoverLoader(), modules);
    }

    static ObjectGraph createWith(Loader loader, Object ... modules) {
        return DaggerObjectGraph.makeGraph(null, loader, modules);
    }

    private static final class OverridesBindings
    extends BindingsGroup {
        OverridesBindings() {
        }

        @Override
        public Binding<?> contributeSetBinding(String key, SetBinding<?> value) {
            throw new IllegalArgumentException("Module overrides cannot contribute set bindings.");
        }
    }

    private static final class StandardBindings
    extends BindingsGroup {
        private final List<SetBinding<?>> setBindings;

        public StandardBindings() {
            this.setBindings = new ArrayList();
        }

        public StandardBindings(List<SetBinding<?>> baseSetBindings) {
            this.setBindings = new ArrayList(baseSetBindings.size());
            for (SetBinding<?> sb : baseSetBindings) {
                SetBinding child = new SetBinding(sb);
                this.setBindings.add(child);
                this.put(child.provideKey, child);
            }
        }

        @Override
        public Binding<?> contributeSetBinding(String key, SetBinding<?> value) {
            this.setBindings.add(value);
            return super.put(key, value);
        }
    }

    static class DaggerObjectGraph
    extends ObjectGraph {
        private final DaggerObjectGraph base;
        private final Linker linker;
        private final Loader plugin;
        private final Map<Class<?>, StaticInjection> staticInjections;
        private final Map<String, Class<?>> injectableTypes;
        private final List<SetBinding<?>> setBindings;

        DaggerObjectGraph(DaggerObjectGraph base, Linker linker, Loader plugin, Map<Class<?>, StaticInjection> staticInjections, Map<String, Class<?>> injectableTypes, List<SetBinding<?>> setBindings) {
            this.base = base;
            this.linker = DaggerObjectGraph.checkNotNull(linker, "linker");
            this.plugin = DaggerObjectGraph.checkNotNull(plugin, "plugin");
            this.staticInjections = DaggerObjectGraph.checkNotNull(staticInjections, "staticInjections");
            this.injectableTypes = DaggerObjectGraph.checkNotNull(injectableTypes, "injectableTypes");
            this.setBindings = DaggerObjectGraph.checkNotNull(setBindings, "setBindings");
        }

        private static <T> T checkNotNull(T object, String label) {
            if (object == null) {
                throw new NullPointerException(label);
            }
            return object;
        }

        static ObjectGraph makeGraph(DaggerObjectGraph base, Loader plugin, Object ... modules) {
            LinkedHashMap injectableTypes = new LinkedHashMap();
            LinkedHashMap staticInjections = new LinkedHashMap();
            StandardBindings baseBindings = base == null ? new StandardBindings() : new StandardBindings(base.setBindings);
            OverridesBindings overrideBindings = new OverridesBindings();
            Map<ModuleAdapter<?>, Object> loadedModules = Modules.loadModules(plugin, modules);
            for (Map.Entry<ModuleAdapter<?>, Object> loadedModule : loadedModules.entrySet()) {
                int i;
                ModuleAdapter<?> moduleAdapter = loadedModule.getKey();
                for (i = 0; i < moduleAdapter.injectableTypes.length; ++i) {
                    injectableTypes.put(moduleAdapter.injectableTypes[i], moduleAdapter.moduleClass);
                }
                for (i = 0; i < moduleAdapter.staticInjections.length; ++i) {
                    staticInjections.put(moduleAdapter.staticInjections[i], null);
                }
                try {
                    BindingsGroup addTo = moduleAdapter.overrides ? overrideBindings : baseBindings;
                    moduleAdapter.getBindings(addTo, loadedModule.getValue());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(moduleAdapter.moduleClass.getSimpleName() + ": " + e.getMessage(), e);
                }
            }
            Linker linker = new Linker(base != null ? base.linker : null, plugin, new ThrowingErrorHandler());
            linker.installBindings(baseBindings);
            linker.installBindings(overrideBindings);
            return new DaggerObjectGraph(base, linker, plugin, staticInjections, injectableTypes, baseBindings.setBindings);
        }

        @Override
        public ObjectGraph plus(Object ... modules) {
            this.linkEverything();
            return DaggerObjectGraph.makeGraph(this, this.plugin, modules);
        }

        private void linkStaticInjections() {
            for (Map.Entry<Class<?>, StaticInjection> entry : this.staticInjections.entrySet()) {
                StaticInjection staticInjection = entry.getValue();
                if (staticInjection == null) {
                    staticInjection = this.plugin.getStaticInjection(entry.getKey());
                    entry.setValue(staticInjection);
                }
                staticInjection.attach(this.linker);
            }
        }

        private void linkInjectableTypes() {
            for (Map.Entry<String, Class<?>> entry : this.injectableTypes.entrySet()) {
                this.linker.requestBinding(entry.getKey(), entry.getValue(), entry.getValue().getClassLoader(), false, true);
            }
        }

        @Override
        public void validate() {
            Map<String, Binding<?>> allBindings = this.linkEverything();
            new ProblemDetector().detectProblems(allBindings.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Binding<?>> linkEverything() {
            Map<String, Binding<?>> bindings = this.linker.fullyLinkedBindings();
            if (bindings != null) {
                return bindings;
            }
            Linker linker = this.linker;
            synchronized (linker) {
                bindings = this.linker.fullyLinkedBindings();
                if (bindings != null) {
                    return bindings;
                }
                this.linkStaticInjections();
                this.linkInjectableTypes();
                return this.linker.linkAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void injectStatics() {
            Linker linker = this.linker;
            synchronized (linker) {
                this.linkStaticInjections();
                this.linker.linkRequested();
                this.linkStaticInjections();
            }
            for (Map.Entry<Class<?>, StaticInjection> entry : this.staticInjections.entrySet()) {
                entry.getValue().inject();
            }
        }

        @Override
        public <T> T get(Class<T> type) {
            String key = Keys.get(type);
            String injectableTypeKey = type.isInterface() ? key : Keys.getMembersKey(type);
            ClassLoader classLoader = type.getClassLoader();
            Binding<?> binding = this.getInjectableTypeBinding(classLoader, injectableTypeKey, key);
            return (T)binding.get();
        }

        @Override
        public <T> T inject(T instance) {
            String membersKey = Keys.getMembersKey(instance.getClass());
            ClassLoader classLoader = instance.getClass().getClassLoader();
            Binding<?> binding = this.getInjectableTypeBinding(classLoader, membersKey, membersKey);
            binding.injectMembers(instance);
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Binding<?> getInjectableTypeBinding(ClassLoader classLoader, String injectableKey, String key) {
            Class<?> moduleClass = null;
            DaggerObjectGraph graph = this;
            while (graph != null && (moduleClass = graph.injectableTypes.get(injectableKey)) == null) {
                graph = graph.base;
            }
            if (moduleClass == null) {
                throw new IllegalArgumentException("No inject registered for " + injectableKey + ". You must explicitly add it to the 'injects' option in one of your modules.");
            }
            Linker linker = this.linker;
            synchronized (linker) {
                Binding<?> binding = this.linker.requestBinding(key, moduleClass, classLoader, false, true);
                if (binding == null || !binding.isLinked()) {
                    this.linker.linkRequested();
                    binding = this.linker.requestBinding(key, moduleClass, classLoader, false, true);
                }
                return binding;
            }
        }
    }
}

