/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.elasticsearch.core.bulk.BulkResponseItem;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.SimpleJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import jakarta.json.Json;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.elasticsearch.JsonpMapperFactory;
import org.apache.beam.sdk.io.elasticsearch.ThrowingConsumer;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.TimestampCombiner;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchIO {

    public static class Write {
        private static final Logger LOG = LoggerFactory.getLogger(Write.class);
        private static final String RETRY_ATTEMPT_LOG = "Error writing to Elasticsearch. Retry attempt[%d]";
        private static final String RETRY_FAILED_LOG = "Error writing to ES after %d attempt(s). No more attempts allowed";

        public static <T> Bound<T> withNodes(HttpHost[] httpHostArray) {
            return new Bound().withNodes(httpHostArray);
        }

        public static <T> Bound withFlushInterval(Duration duration) {
            return new Bound().withFlushInterval(duration);
        }

        public static <T> Bound withFunction(SerializableFunction<T, Iterable<BulkOperation>> serializableFunction) {
            return new Bound<T>().withFunction(serializableFunction);
        }

        public static <T> Bound withNumOfShard(long l) {
            return new Bound().withNumOfShard(l);
        }

        public static <T> Bound withError(ThrowingConsumer<BulkExecutionException> throwingConsumer) {
            return new Bound().withError(throwingConsumer);
        }

        public static <T> Bound withMaxBulkRequestOperations(int n) {
            return new Bound().withMaxBulkRequestOperations(n);
        }

        public static <T> Bound withMaxBulkRequestBytes(long l) {
            return new Bound().withMaxBulkRequestBytes(l);
        }

        public static <T> Bound withMaxRetries(int n) {
            return new Bound().withMaxRetries(n);
        }

        public static <T> Bound withRetryPause(Duration duration) {
            return new Bound().withRetryPause(duration);
        }

        public static <T> Bound withCredentials(UsernamePasswordCredentials usernamePasswordCredentials) {
            return new Bound().withCredentials(usernamePasswordCredentials);
        }

        private static long operationSize(ClientSupplier clientSupplier, BulkOperation bulkOperation) {
            CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
            bulkOperation.serialize(Json.createGenerator((OutputStream)countingOutputStream), clientSupplier.getJsonMapper());
            return countingOutputStream.getByteCount();
        }

        private static ProcessFunction<BulkRequest, BulkResponse> request(ClientSupplier clientSupplier, ThrowingConsumer<BulkExecutionException> throwingConsumer) {
            return (ProcessFunction & Serializable)bulkRequest -> {
                BulkResponse bulkResponse = clientSupplier.get().bulk(bulkRequest);
                if (bulkResponse.errors()) {
                    throwingConsumer.accept(new BulkExecutionException(bulkResponse));
                }
                return bulkResponse;
            };
        }

        private static ProcessFunction<BulkRequest, BulkResponse> retry(ProcessFunction<BulkRequest, BulkResponse> processFunction, FluentBackoff fluentBackoff) {
            return (ProcessFunction & Serializable)bulkRequest -> {
                BackOff backOff = fluentBackoff.backoff();
                int n = 0;
                BulkResponse bulkResponse = null;
                Exception exception = null;
                while (bulkResponse == null && BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)backOff)) {
                    LOG.warn(String.format(RETRY_ATTEMPT_LOG, ++n));
                    try {
                        bulkResponse = (BulkResponse)processFunction.apply(bulkRequest);
                        exception = null;
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                    }
                }
                if (exception != null) {
                    throw new Exception(String.format(RETRY_FAILED_LOG, n), exception);
                }
                return bulkResponse;
            };
        }

        private static ThrowingConsumer<BulkExecutionException> defaultErrorHandler() {
            return bulkExecutionException -> {
                throw bulkExecutionException;
            };
        }

        public static class BulkExecutionException
        extends IOException {
            private final Iterable<ErrorCause> failures;

            BulkExecutionException(BulkResponse bulkResponse) {
                super(BulkExecutionException.buildFailureMessage(bulkResponse));
                this.failures = BulkExecutionException.buildFailures(bulkResponse);
            }

            public Iterable<ErrorCause> getFailures() {
                return this.failures;
            }

            private static Iterable<ErrorCause> buildFailures(BulkResponse bulkResponse) {
                return bulkResponse.items().stream().map(BulkResponseItem::error).filter(Objects::nonNull).collect(Collectors.toList());
            }

            private static String buildFailureMessage(BulkResponse bulkResponse) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("failure in bulk execution:");
                for (BulkResponseItem bulkResponseItem : bulkResponse.items()) {
                    ErrorCause errorCause = bulkResponseItem.error();
                    if (errorCause == null) continue;
                    stringBuilder.append("\n[").append(bulkResponseItem).append("]: index [").append(bulkResponseItem.index()).append("], type [").append(bulkResponseItem.operationType()).append("], id [").append(bulkResponseItem.id()).append("], message [").append(errorCause.reason()).append("]");
                }
                return stringBuilder.toString();
            }
        }

        private static class ClientSupplier
        implements Supplier<ElasticsearchClient>,
        Serializable {
            private final AtomicReference<RestClientTransport> transport = new AtomicReference();
            private final HttpHost[] nodes;
            private final UsernamePasswordCredentials credentials;
            private final JsonpMapperFactory mapperFactory;

            public ClientSupplier(HttpHost[] httpHostArray, UsernamePasswordCredentials usernamePasswordCredentials, JsonpMapperFactory jsonpMapperFactory) {
                this.nodes = httpHostArray;
                this.credentials = usernamePasswordCredentials;
                this.mapperFactory = jsonpMapperFactory;
            }

            @Override
            public ElasticsearchClient get() {
                return new ElasticsearchClient((ElasticsearchTransport)this.getTransport());
            }

            public RestClientTransport getTransport() {
                return this.transport.updateAndGet(restClientTransport -> restClientTransport == null ? this.createTransport() : restClientTransport);
            }

            public JsonpMapper getJsonMapper() {
                return this.getTransport().jsonpMapper();
            }

            private RestClientTransport createTransport() {
                RestClient restClient;
                RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.nodes);
                if (this.credentials != null) {
                    restClient = new BasicCredentialsProvider();
                    restClient.setCredentials(AuthScope.ANY, (Credentials)this.credentials);
                    restClientBuilder.setHttpClientConfigCallback(arg_0 -> ClientSupplier.lambda$createTransport$1((CredentialsProvider)restClient, arg_0));
                }
                restClient = restClientBuilder.build();
                return new RestClientTransport(restClient, this.mapperFactory.create());
            }

            private static /* synthetic */ HttpAsyncClientBuilder lambda$createTransport$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
                return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
            }
        }

        private static class ElasticsearchShardWriter<T>
        extends DoFn<KV<Long, Iterable<T>>, Void> {
            private List<BulkOperation> chunk;
            private long chunkBytes;
            private final ClientSupplier clientSupplier;
            private final SerializableFunction<T, Iterable<BulkOperation>> toBulkOperations;
            private final ThrowingConsumer<BulkExecutionException> error;
            private final int maxBulkRequestOperations;
            private final long maxBulkRequestBytes;
            private final int maxRetries;
            private final Duration retryPause;
            private ProcessFunction<BulkRequest, BulkResponse> requestFn;
            private ProcessFunction<BulkRequest, BulkResponse> retryFn;

            public ElasticsearchShardWriter(HttpHost[] httpHostArray, int n, long l, SerializableFunction<T, Iterable<BulkOperation>> serializableFunction, ThrowingConsumer<BulkExecutionException> throwingConsumer, int n2, Duration duration, UsernamePasswordCredentials usernamePasswordCredentials, JsonpMapperFactory jsonpMapperFactory) {
                this.maxBulkRequestOperations = n;
                this.maxBulkRequestBytes = l;
                this.clientSupplier = new ClientSupplier(httpHostArray, usernamePasswordCredentials, jsonpMapperFactory);
                this.toBulkOperations = serializableFunction;
                this.error = throwingConsumer;
                this.maxRetries = n2;
                this.retryPause = duration;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                Preconditions.checkArgument((boolean)this.clientSupplier.get().ping().value(), (Object)"Elasticsearch client not reachable");
                FluentBackoff fluentBackoff = FluentBackoff.DEFAULT.withMaxRetries(this.maxRetries).withInitialBackoff(this.retryPause);
                this.requestFn = Write.request(this.clientSupplier, this.error);
                this.retryFn = Write.retry((ProcessFunction<BulkRequest, BulkResponse>)this.requestFn, fluentBackoff);
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                this.clientSupplier.getTransport().close();
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext startBundleContext) {
                this.chunk = new ArrayList<BulkOperation>();
                this.chunkBytes = 0L;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<Long, Iterable<T>> kV) throws Exception {
                Iterable iterable = (Iterable)kV.getValue();
                Iterable iterable2 = () -> StreamSupport.stream(iterable.spliterator(), false).map(arg_0 -> this.toBulkOperations.apply(arg_0)).flatMap(iterable -> StreamSupport.stream(iterable.spliterator(), false)).iterator();
                for (BulkOperation bulkOperation : iterable2) {
                    long l = Write.operationSize(this.clientSupplier, bulkOperation);
                    if (this.chunk.size() + 1 > this.maxBulkRequestOperations || this.chunkBytes + l > (long)this.maxBulkRequestOperations) {
                        this.flush();
                    }
                    this.chunk.add(bulkOperation);
                }
                this.flush();
            }

            private void flush() throws Exception {
                if (this.chunk.isEmpty()) {
                    return;
                }
                BulkRequest bulkRequest = BulkRequest.of(builder -> builder.operations(this.chunk));
                try {
                    this.requestFn.apply((Object)bulkRequest);
                }
                catch (Exception exception) {
                    this.retryFn.apply((Object)bulkRequest);
                }
                this.chunk.clear();
                this.chunkBytes = 0L;
            }
        }

        private static class ElasticsearchWriter<T>
        extends DoFn<T, Void> {
            private List<BulkOperation> chunk;
            private long chunkBytes;
            private final ClientSupplier clientSupplier;
            private final SerializableFunction<T, Iterable<BulkOperation>> toBulkOperations;
            private final ThrowingConsumer<BulkExecutionException> error;
            private final int maxBulkRequestOperations;
            private final long maxBulkRequestBytes;
            private final int maxRetries;
            private final Duration retryPause;
            private ProcessFunction<BulkRequest, BulkResponse> requestFn;
            private ProcessFunction<BulkRequest, BulkResponse> retryFn;

            public ElasticsearchWriter(HttpHost[] httpHostArray, int n, long l, SerializableFunction<T, Iterable<BulkOperation>> serializableFunction, ThrowingConsumer<BulkExecutionException> throwingConsumer, int n2, Duration duration, UsernamePasswordCredentials usernamePasswordCredentials, JsonpMapperFactory jsonpMapperFactory) {
                this.maxBulkRequestOperations = n;
                this.maxBulkRequestBytes = l;
                this.clientSupplier = new ClientSupplier(httpHostArray, usernamePasswordCredentials, jsonpMapperFactory);
                this.toBulkOperations = serializableFunction;
                this.error = throwingConsumer;
                this.maxRetries = n2;
                this.retryPause = duration;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                Preconditions.checkArgument((boolean)this.clientSupplier.get().ping().value(), (Object)"Elasticsearch client not reachable");
                FluentBackoff fluentBackoff = FluentBackoff.DEFAULT.withMaxRetries(this.maxRetries).withInitialBackoff(this.retryPause);
                this.requestFn = Write.request(this.clientSupplier, this.error);
                this.retryFn = Write.retry((ProcessFunction<BulkRequest, BulkResponse>)this.requestFn, fluentBackoff);
            }

            @DoFn.Teardown
            public void teardown() throws Exception {
                this.clientSupplier.getTransport().close();
            }

            @DoFn.StartBundle
            public void startBundle(DoFn.StartBundleContext startBundleContext) {
                this.chunk = new ArrayList<BulkOperation>();
                this.chunkBytes = 0L;
            }

            @DoFn.FinishBundle
            public void finishBundle() throws Exception {
                this.flush();
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element T t) throws Exception {
                Iterable iterable = (Iterable)this.toBulkOperations.apply(t);
                for (BulkOperation bulkOperation : iterable) {
                    long l = Write.operationSize(this.clientSupplier, bulkOperation);
                    if (this.chunk.size() + 1 > this.maxBulkRequestOperations || this.chunkBytes + l > this.maxBulkRequestBytes) {
                        this.flush();
                    }
                    this.chunk.add(bulkOperation);
                    this.chunkBytes += l;
                }
            }

            private void flush() throws Exception {
                if (this.chunk.isEmpty()) {
                    return;
                }
                BulkRequest bulkRequest = BulkRequest.of(builder -> builder.operations(this.chunk));
                try {
                    this.requestFn.apply((Object)bulkRequest);
                }
                catch (Exception exception) {
                    this.retryFn.apply((Object)bulkRequest);
                }
                this.chunk.clear();
                this.chunkBytes = 0L;
            }
        }

        private static class AssignToShard<T>
        extends DoFn<T, KV<Long, T>> {
            private final long numOfShard;

            public AssignToShard(long l) {
                this.numOfShard = l;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element T t, DoFn.OutputReceiver<KV<Long, T>> outputReceiver) throws Exception {
                long l = ThreadLocalRandom.current().nextLong(this.numOfShard);
                outputReceiver.output((Object)KV.of((Object)l, t));
            }
        }

        public static class Bound<T>
        extends PTransform<PCollection<T>, PDone> {
            private static final int CHUNK_SIZE = 3000;
            private static final long CHUNK_BYTES = 0x500000L;
            private static final int DEFAULT_RETRIES = 3;
            private static final Duration DEFAULT_RETRY_PAUSE = Duration.millis((long)35000L);
            private final HttpHost[] nodes;
            private final Duration flushInterval;
            private final SerializableFunction<T, Iterable<BulkOperation>> toBulkOperations;
            private final long numOfShard;
            private final int maxBulkRequestOperations;
            private final long maxBulkRequestBytes;
            private final int maxRetries;
            private final Duration retryPause;
            private final ThrowingConsumer<BulkExecutionException> error;
            private final UsernamePasswordCredentials credentials;
            private final JsonpMapperFactory mapperFactory;

            private Bound(HttpHost[] httpHostArray, Duration duration, SerializableFunction<T, Iterable<BulkOperation>> serializableFunction, long l, int n, long l2, int n2, Duration duration2, ThrowingConsumer<BulkExecutionException> throwingConsumer, UsernamePasswordCredentials usernamePasswordCredentials, JsonpMapperFactory jsonpMapperFactory) {
                this.nodes = httpHostArray;
                this.flushInterval = duration;
                this.toBulkOperations = serializableFunction;
                this.numOfShard = l;
                this.maxBulkRequestOperations = n;
                this.maxBulkRequestBytes = l2;
                this.maxRetries = n2;
                this.retryPause = duration2;
                this.error = throwingConsumer;
                this.credentials = usernamePasswordCredentials;
                this.mapperFactory = jsonpMapperFactory;
            }

            Bound() {
                this(null, null, null, 0L, 3000, 0x500000L, 3, DEFAULT_RETRY_PAUSE, Write.defaultErrorHandler(), null, SimpleJsonpMapper::new);
            }

            public Bound<T> withNodes(HttpHost[] httpHostArray) {
                return new Bound<T>(httpHostArray, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withFlushInterval(Duration duration) {
                return new Bound<T>(this.nodes, duration, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withFunction(SerializableFunction<T, Iterable<BulkOperation>> serializableFunction) {
                return new Bound<T>(this.nodes, this.flushInterval, serializableFunction, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withNumOfShard(long l) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, l, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withError(ThrowingConsumer<BulkExecutionException> throwingConsumer) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, throwingConsumer, this.credentials, this.mapperFactory);
            }

            public Bound<T> withMaxBulkRequestOperations(int n) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, n, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withMaxBulkRequestBytes(long l) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, l, this.maxRetries, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withMaxRetries(int n) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, n, this.retryPause, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withRetryPause(Duration duration) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, duration, this.error, this.credentials, this.mapperFactory);
            }

            public Bound<T> withCredentials(UsernamePasswordCredentials usernamePasswordCredentials) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, usernamePasswordCredentials, this.mapperFactory);
            }

            public Bound<T> withMapperFactory(JsonpMapperFactory jsonpMapperFactory) {
                return new Bound<T>(this.nodes, this.flushInterval, this.toBulkOperations, this.numOfShard, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.maxRetries, this.retryPause, this.error, this.credentials, jsonpMapperFactory);
            }

            public PDone expand(PCollection<T> pCollection) {
                Preconditions.checkNotNull((Object)this.nodes);
                Preconditions.checkNotNull(this.toBulkOperations);
                Preconditions.checkNotNull((Object)this.flushInterval);
                Preconditions.checkNotNull((Object)this.mapperFactory);
                Preconditions.checkArgument((this.numOfShard >= 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.maxBulkRequestOperations > 0 ? 1 : 0) != 0);
                Preconditions.checkArgument((this.maxBulkRequestBytes > 0L ? 1 : 0) != 0);
                Preconditions.checkArgument((this.maxRetries >= 0 ? 1 : 0) != 0);
                Preconditions.checkArgument((this.retryPause.getMillis() >= 0L ? 1 : 0) != 0);
                if (this.numOfShard == 0L) {
                    pCollection.apply((PTransform)ParDo.of(new ElasticsearchWriter<T>(this.nodes, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.toBulkOperations, this.error, this.maxRetries, this.retryPause, this.credentials, this.mapperFactory)));
                } else {
                    ((PCollection)((PCollection)((PCollection)pCollection.apply("Assign To Shard", (PTransform)ParDo.of(new AssignToShard(this.numOfShard)))).apply("Re-Window to Global Window", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.flushInterval))).discardingFiredPanes().withTimestampCombiner(TimestampCombiner.END_OF_WINDOW))).apply((PTransform)GroupByKey.create())).apply("Write to Elasticsearch", (PTransform)ParDo.of(new ElasticsearchShardWriter<T>(this.nodes, this.maxBulkRequestOperations, this.maxBulkRequestBytes, this.toBulkOperations, this.error, this.maxRetries, this.retryPause, this.credentials, this.mapperFactory)));
                }
                return PDone.in((Pipeline)pCollection.getPipeline());
            }
        }
    }
}

