/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.elasticsearch;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.mapping.TypeMapping;
import co.elastic.clients.elasticsearch.indices.CreateIndexRequest;
import co.elastic.clients.elasticsearch.indices.CreateIndexResponse;
import co.elastic.clients.elasticsearch.indices.DeleteIndexRequest;
import co.elastic.clients.elasticsearch.indices.DeleteIndexResponse;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.elasticsearch.indices.GetAliasRequest;
import co.elastic.clients.elasticsearch.indices.GetAliasResponse;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesRequest;
import co.elastic.clients.elasticsearch.indices.UpdateAliasesResponse;
import co.elastic.clients.elasticsearch.indices.update_aliases.Action;
import co.elastic.clients.elasticsearch.indices.update_aliases.AddAction;
import co.elastic.clients.elasticsearch.indices.update_aliases.RemoveAction;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import com.spotify.scio.elasticsearch.IndexAdmin$$anonfun$com$spotify$scio$elasticsearch$IndexAdmin$;
import com.spotify.scio.elasticsearch.package;
import java.io.Serializable;
import java.util.function.Function;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

public final class IndexAdmin$ {
    public static final IndexAdmin$ MODULE$ = new IndexAdmin$();
    private static final Logger Logger = LoggerFactory.getLogger(MODULE$.getClass());

    private <A> Try<A> indicesClient(package.ElasticsearchOptions esOptions, Function1<ElasticsearchIndicesClient, A> f) {
        Option provider = esOptions.usernameAndPassword().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final BasicCredentialsProvider apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String username = (String)tuple2._1();
                String password = (String)tuple2._2();
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                BasicCredentialsProvider basicCredentialsProvider = provider;
                return basicCredentialsProvider;
            }
        });
        RestClientBuilder builder = RestClient.builder((HttpHost[])((HttpHost[])esOptions.nodes().toArray(ClassTag$.MODULE$.apply(HttpHost.class))));
        provider.foreach((Function1)new Serializable(builder){
            private static final long serialVersionUID = 0L;
            private final RestClientBuilder builder$1;

            public final RestClientBuilder apply(BasicCredentialsProvider p) {
                return this.builder$1.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(this, p){
                    private final BasicCredentialsProvider p$1;

                    public final HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder x$1) {
                        return x$1.setDefaultCredentialsProvider((CredentialsProvider)this.p$1);
                    }
                    {
                        this.p$1 = p$1;
                    }
                });
            }
            {
                this.builder$1 = builder$1;
            }
        });
        RestClient restClient = builder.build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        ElasticsearchClient client = new ElasticsearchClient((ElasticsearchTransport)transport);
        Try result = Try$.MODULE$.apply((Function0)new Serializable(f, client){
            private static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final ElasticsearchClient client$1;

            public final A apply() {
                return (A)this.f$1.apply((Object)this.client$1.indices());
            }
            {
                this.f$1 = f$1;
                this.client$1 = client$1;
            }
        });
        transport.close();
        return result;
    }

    public CreateIndexResponse com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(String index, TypeMapping typeMappings, ElasticsearchIndicesClient client) {
        return client.create(CreateIndexRequest.of((Function)new Function<CreateIndexRequest.Builder, ObjectBuilder<CreateIndexRequest>>(index, typeMappings){
            private final String index$1;
            private final TypeMapping typeMappings$1;

            public <V> Function<V, ObjectBuilder<CreateIndexRequest>> compose(Function<? super V, ? extends CreateIndexRequest.Builder> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<CreateIndexRequest.Builder, V> andThen(Function<? super ObjectBuilder<CreateIndexRequest>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public final ObjectBuilder<CreateIndexRequest> apply(CreateIndexRequest.Builder x$1) {
                return x$1.index(this.index$1).mappings(this.typeMappings$1);
            }
            {
                this.index$1 = index$1;
                this.typeMappings$1 = typeMappings$1;
            }
        }));
    }

    public Try<CreateIndexResponse> ensureIndex(package.ElasticsearchOptions esOptions, String index, TypeMapping typeMappings) {
        return this.indicesClient(esOptions, (Function1)new Serializable(index, typeMappings){
            private static final long serialVersionUID = 0L;
            private final String index$2;
            private final TypeMapping typeMappings$2;

            public final CreateIndexResponse apply(ElasticsearchIndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(this.index$2, this.typeMappings$2, client);
            }
            {
                this.index$2 = index$2;
                this.typeMappings$2 = typeMappings$2;
            }
        });
    }

    public DeleteIndexResponse com$spotify$scio$elasticsearch$IndexAdmin$$removeIndex(ElasticsearchIndicesClient client, String index, Time timeout) {
        return client.delete(DeleteIndexRequest.of((Function)new Function<DeleteIndexRequest.Builder, ObjectBuilder<DeleteIndexRequest>>(index, timeout){
            private final String index$3;
            private final Time timeout$1;

            public <V> Function<V, ObjectBuilder<DeleteIndexRequest>> compose(Function<? super V, ? extends DeleteIndexRequest.Builder> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<DeleteIndexRequest.Builder, V> andThen(Function<? super ObjectBuilder<DeleteIndexRequest>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public final ObjectBuilder<DeleteIndexRequest> apply(DeleteIndexRequest.Builder x$1) {
                return x$1.index(this.index$3, new String[0]).timeout(this.timeout$1);
            }
            {
                this.index$3 = index$3;
                this.timeout$1 = timeout$1;
            }
        }));
    }

    public Try<DeleteIndexResponse> removeIndex(package.ElasticsearchOptions esOptions, String index, Time timeout) {
        return this.indicesClient(esOptions, (Function1)new Serializable(index, timeout){
            private static final long serialVersionUID = 0L;
            private final String index$4;
            private final Time timeout$2;

            public final DeleteIndexResponse apply(ElasticsearchIndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$removeIndex(client, this.index$4, this.timeout$2);
            }
            {
                this.index$4 = index$4;
                this.timeout$2 = timeout$2;
            }
        });
    }

    public UpdateAliasesResponse com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias(ElasticsearchIndicesClient client, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, Time timeout) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = indices.toList().partitionMap((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Either<String, String> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String idx = (String)tuple2._1();
                    boolean bl = tuple2._2$mcZ$sp();
                    if (bl) {
                        return package$.MODULE$.Left().apply((Object)idx);
                    }
                }
                if (tuple2 == null) throw new MatchError(tuple2);
                String idx = (String)tuple2._1();
                boolean bl = tuple2._2$mcZ$sp();
                if (false != bl) throw new MatchError(tuple2);
                return package$.MODULE$.Right().apply((Object)idx);
            }
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List writeIdx = (List)tuple2._1();
        List idxs = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)writeIdx, (Object)idxs);
        Tuple2 tuple23 = tuple22;
        List writeIdx2 = (List)tuple23._1();
        List idxs2 = (List)tuple23._2();
        Predef$.MODULE$.require(writeIdx2.size() == 1, (Function0)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final String apply() {
                return "Only one index per alias can be assigned to be the write index at a time";
            }
        });
        Builder actionsBuilder = package$.MODULE$.List().newBuilder();
        actionsBuilder.$plus$eq((Object)Action.of((Function)new Function<Action.Builder, ObjectBuilder<Action>>(writeIdx2, alias){
            public final List writeIdx$1;
            public final String alias$1;

            public <V> Function<V, ObjectBuilder<Action>> compose(Function<? super V, ? extends Action.Builder> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Action.Builder, V> andThen(Function<? super ObjectBuilder<Action>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public final ObjectBuilder<Action> apply(Action.Builder x$1) {
                return x$1.add((Function)new Function<AddAction.Builder, ObjectBuilder<AddAction>>(this){
                    private final /* synthetic */ anonfun$com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias$2 $outer;

                    public <V> Function<V, ObjectBuilder<AddAction>> compose(Function<? super V, ? extends AddAction.Builder> x$1) {
                        return Function.super.compose(x$1);
                    }

                    public <V> Function<AddAction.Builder, V> andThen(Function<? super ObjectBuilder<AddAction>, ? extends V> x$1) {
                        return Function.super.andThen(x$1);
                    }

                    public final ObjectBuilder<AddAction> apply(AddAction.Builder x$1) {
                        return x$1.indices(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.$outer.writeIdx$1).asJava()).isWriteIndex(Predef$.MODULE$.boolean2Boolean(true)).alias(this.$outer.alias$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.writeIdx$1 = writeIdx$1;
                this.alias$1 = alias$1;
            }
        }));
        actionsBuilder.$plus$eq((Object)Action.of((Function)new Function<Action.Builder, ObjectBuilder<Action>>(idxs2, alias){
            public final List idxs$1;
            public final String alias$1;

            public <V> Function<V, ObjectBuilder<Action>> compose(Function<? super V, ? extends Action.Builder> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<Action.Builder, V> andThen(Function<? super ObjectBuilder<Action>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public final ObjectBuilder<Action> apply(Action.Builder x$1) {
                return x$1.add((Function)new Function<AddAction.Builder, ObjectBuilder<AddAction>>(this){
                    private final /* synthetic */ anonfun$com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias$3 $outer;

                    public <V> Function<V, ObjectBuilder<AddAction>> compose(Function<? super V, ? extends AddAction.Builder> x$1) {
                        return Function.super.compose(x$1);
                    }

                    public <V> Function<AddAction.Builder, V> andThen(Function<? super ObjectBuilder<AddAction>, ? extends V> x$1) {
                        return Function.super.andThen(x$1);
                    }

                    public final ObjectBuilder<AddAction> apply(AddAction.Builder x$1) {
                        return x$1.indices(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.$outer.idxs$1).asJava()).isWriteIndex(Predef$.MODULE$.boolean2Boolean(false)).alias(this.$outer.alias$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.idxs$1 = idxs$1;
                this.alias$1 = alias$1;
            }
        }));
        if (removePrevious) {
            GetAliasResponse getAliasesResponse = client.getAlias(GetAliasRequest.of((Function)new Function<GetAliasRequest.Builder, ObjectBuilder<GetAliasRequest>>(alias){
                private final String alias$1;

                public <V> Function<V, ObjectBuilder<GetAliasRequest>> compose(Function<? super V, ? extends GetAliasRequest.Builder> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<GetAliasRequest.Builder, V> andThen(Function<? super ObjectBuilder<GetAliasRequest>, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public final ObjectBuilder<GetAliasRequest> apply(GetAliasRequest.Builder x$1) {
                    return x$1.name(this.alias$1, new String[0]);
                }
                {
                    this.alias$1 = alias$1;
                }
            }));
            List indicesToRemove = CollectionConverters$.MODULE$.MapHasAsScala(getAliasesResponse.result()).asScala().keys().toList();
            Logger.info(new StringBuilder(21).append("Removing alias ").append(alias).append(" from ").append(indicesToRemove.mkString(", ")).toString());
            boxedUnit = actionsBuilder.$plus$eq((Object)Action.of((Function)new Function<Action.Builder, ObjectBuilder<Action>>(indicesToRemove, alias){
                public final List indicesToRemove$1;
                public final String alias$1;

                public <V> Function<V, ObjectBuilder<Action>> compose(Function<? super V, ? extends Action.Builder> x$1) {
                    return Function.super.compose(x$1);
                }

                public <V> Function<Action.Builder, V> andThen(Function<? super ObjectBuilder<Action>, ? extends V> x$1) {
                    return Function.super.andThen(x$1);
                }

                public final ObjectBuilder<Action> apply(Action.Builder x$1) {
                    return x$1.remove((Function)new Function<RemoveAction.Builder, ObjectBuilder<RemoveAction>>(this){
                        private final /* synthetic */ anonfun$com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias$4 $outer;

                        public <V> Function<V, ObjectBuilder<RemoveAction>> compose(Function<? super V, ? extends RemoveAction.Builder> x$1) {
                            return Function.super.compose(x$1);
                        }

                        public <V> Function<RemoveAction.Builder, V> andThen(Function<? super ObjectBuilder<RemoveAction>, ? extends V> x$1) {
                            return Function.super.andThen(x$1);
                        }

                        public final ObjectBuilder<RemoveAction> apply(RemoveAction.Builder x$1) {
                            return x$1.indices(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.$outer.indicesToRemove$1).asJava()).alias(this.$outer.alias$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.indicesToRemove$1 = indicesToRemove$1;
                    this.alias$1 = alias$1;
                }
            }));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return client.updateAliases(UpdateAliasesRequest.of((Function)new Function<UpdateAliasesRequest.Builder, ObjectBuilder<UpdateAliasesRequest>>(actionsBuilder, timeout){
            private final Builder actionsBuilder$1;
            private final Time timeout$3;

            public <V> Function<V, ObjectBuilder<UpdateAliasesRequest>> compose(Function<? super V, ? extends UpdateAliasesRequest.Builder> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<UpdateAliasesRequest.Builder, V> andThen(Function<? super ObjectBuilder<UpdateAliasesRequest>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public final ObjectBuilder<UpdateAliasesRequest> apply(UpdateAliasesRequest.Builder x$1) {
                return x$1.actions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.actionsBuilder$1.result()).asJava()).timeout(this.timeout$3);
            }
            {
                this.actionsBuilder$1 = actionsBuilder$1;
                this.timeout$3 = timeout$3;
            }
        }));
    }

    public Try<UpdateAliasesResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, String alias, String index, boolean removePrevious, Time timeout) {
        return this.createOrUpdateAlias(esOptions, (Iterable<Tuple2<String, Object>>)((Iterable)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)index, (Object)BoxesRunTime.boxToBoolean((boolean)true))}))), alias, removePrevious, timeout);
    }

    public Try<UpdateAliasesResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, Time timeout) {
        return this.indicesClient(esOptions, (Function1)new Serializable(indices, alias, removePrevious, timeout){
            private static final long serialVersionUID = 0L;
            private final Iterable indices$1;
            private final String alias$2;
            private final boolean removePrevious$1;
            private final Time timeout$4;

            public final UpdateAliasesResponse apply(ElasticsearchIndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias(client, (Iterable<Tuple2<String, Object>>)this.indices$1, this.alias$2, this.removePrevious$1, this.timeout$4);
            }
            {
                this.indices$1 = indices$1;
                this.alias$2 = alias$2;
                this.removePrevious$1 = removePrevious$1;
                this.timeout$4 = timeout$4;
            }
        });
    }

    private IndexAdmin$() {
    }
}

