/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.scio.elasticsearch;

import com.spotify.scio.elasticsearch.package;
import java.io.Serializable;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class IndexAdmin$ {
    public static final IndexAdmin$ MODULE$ = new IndexAdmin$();
    private static final Logger Logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static volatile boolean bitmap$init$0 = true;

    private <A> Try<A> indicesClient(package.ElasticsearchOptions esOptions, Function1<IndicesClient, A> f) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])((HttpHost[])esOptions.nodes().toArray(ClassTag$.MODULE$.apply(HttpHost.class)))).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(esOptions){
            private final package.ElasticsearchOptions esOptions$1;

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                HttpAsyncClientBuilder httpAsyncClientBuilder;
                Option credentialsProdiver = this.esOptions$1.usernameAndPassword().map((Function1)new Serializable(this){
                    private static final long serialVersionUID = 0L;

                    public final BasicCredentialsProvider apply(Tuple2<String, String> x0$1) {
                        Tuple2<String, String> tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        String username = (String)tuple2._1();
                        String password = (String)tuple2._2();
                        BasicCredentialsProvider credentials = new BasicCredentialsProvider();
                        credentials.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
                        BasicCredentialsProvider basicCredentialsProvider = credentials;
                        return basicCredentialsProvider;
                    }
                });
                Option option = credentialsProdiver;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BasicCredentialsProvider provider = (BasicCredentialsProvider)some.value();
                    httpAsyncClientBuilder = httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
                } else if (None$.MODULE$.equals(option)) {
                    httpAsyncClientBuilder = httpClientBuilder;
                } else {
                    throw new MatchError((Object)option);
                }
                return httpAsyncClientBuilder;
            }
            {
                this.esOptions$1 = esOptions$1;
            }
        });
        RestHighLevelClient client = new RestHighLevelClient(builder);
        Try result = Try$.MODULE$.apply((Function0)new Serializable(f, client){
            private static final long serialVersionUID = 0L;
            private final Function1 f$1;
            private final RestHighLevelClient client$1;

            public final A apply() {
                return (A)this.f$1.apply((Object)this.client$1.indices());
            }
            {
                this.f$1 = f$1;
                this.client$1 = client$1;
            }
        });
        client.close();
        return result;
    }

    public CreateIndexResponse com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(String index, String mappingSource, IndicesClient client) {
        return client.create(new CreateIndexRequest(index).source(mappingSource, XContentType.JSON), RequestOptions.DEFAULT);
    }

    public Try<CreateIndexResponse> ensureIndex(package.ElasticsearchOptions esOptions, String index, String mappingSource) {
        return this.indicesClient(esOptions, (Function1)new Serializable(index, mappingSource){
            private static final long serialVersionUID = 0L;
            private final String index$1;
            private final String mappingSource$1;

            public final CreateIndexResponse apply(IndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$ensureIndex(this.index$1, this.mappingSource$1, client);
            }
            {
                this.index$1 = index$1;
                this.mappingSource$1 = mappingSource$1;
            }
        });
    }

    public AcknowledgedResponse com$spotify$scio$elasticsearch$IndexAdmin$$removeIndex(IndicesClient client, String index, TimeValue timeout) {
        return client.delete((DeleteIndexRequest)new DeleteIndexRequest(index).timeout(timeout), RequestOptions.DEFAULT);
    }

    public Try<AcknowledgedResponse> removeIndex(package.ElasticsearchOptions esOptions, String index, TimeValue timeout) {
        return this.indicesClient(esOptions, (Function1)new Serializable(index, timeout){
            private static final long serialVersionUID = 0L;
            private final String index$2;
            private final TimeValue timeout$1;

            public final AcknowledgedResponse apply(IndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$removeIndex(client, this.index$2, this.timeout$1);
            }
            {
                this.index$2 = index$2;
                this.timeout$1 = timeout$1;
            }
        });
    }

    public AcknowledgedResponse com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias(IndicesClient client, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, TimeValue timeout) {
        IndicesAliasesRequest request;
        block0: {
            Predef$.MODULE$.require(Option$.MODULE$.option2Iterable(indices.find((Function1)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> x$1) {
                    return x$1._2$mcZ$sp();
                }
            })).size() == 1, (Function0)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Only one index per alias can be assigned to be the write index at a time";
                }
            });
            request = (IndicesAliasesRequest)indices.foldLeft((Object)new IndicesAliasesRequest(), (Function2)new Serializable(alias){
                private static final long serialVersionUID = 0L;
                private final String alias$1;

                public final IndicesAliasesRequest apply(IndicesAliasesRequest x0$1, Tuple2<String, Object> x1$1) {
                    Tuple2 tuple2;
                    IndicesAliasesRequest request;
                    block3: {
                        Tuple2 tuple22;
                        block2: {
                            tuple22 = new Tuple2((Object)x0$1, x1$1);
                            if (tuple22 == null) break block2;
                            request = (IndicesAliasesRequest)tuple22._1();
                            tuple2 = (Tuple2)tuple22._2();
                            if (tuple2 != null) break block3;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    String idx = (String)tuple2._1();
                    boolean isWriteIndex = tuple2._2$mcZ$sp();
                    IndicesAliasesRequest indicesAliasesRequest = request.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(idx).writeIndex(Predef$.MODULE$.boolean2Boolean(isWriteIndex)).alias(this.alias$1));
                    return indicesAliasesRequest;
                }
                {
                    this.alias$1 = alias$1;
                }
            });
            if (!removePrevious) break block0;
            GetAliasesResponse getAliasesResponse = client.getAlias(new GetAliasesRequest(new String[]{alias}), RequestOptions.DEFAULT);
            Iterable indexAliacesToRemove = CollectionConverters$.MODULE$.MapHasAsScala(getAliasesResponse.getAliases()).asScala().keys();
            Logger.info(new StringBuilder(21).append("Removing alias ").append(alias).append(" from ").append(indexAliacesToRemove.mkString(", ")).toString());
            indexAliacesToRemove.foreach((Function1)new Serializable(request, alias){
                private static final long serialVersionUID = 0L;
                private final IndicesAliasesRequest request$1;
                private final String alias$1;

                public final IndicesAliasesRequest apply(String indexName) {
                    return this.request$1.addAliasAction(new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(indexName).alias(this.alias$1));
                }
                {
                    this.request$1 = request$1;
                    this.alias$1 = alias$1;
                }
            });
        }
        return client.updateAliases((IndicesAliasesRequest)request.timeout(timeout), RequestOptions.DEFAULT);
    }

    public Try<AcknowledgedResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, String alias, String index, boolean removePrevious, TimeValue timeout) {
        return this.createOrUpdateAlias(esOptions, (Iterable<Tuple2<String, Object>>)((Iterable)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)index, (Object)BoxesRunTime.boxToBoolean((boolean)true))}))), alias, removePrevious, timeout);
    }

    public Try<AcknowledgedResponse> createOrUpdateAlias(package.ElasticsearchOptions esOptions, Iterable<Tuple2<String, Object>> indices, String alias, boolean removePrevious, TimeValue timeout) {
        return this.indicesClient(esOptions, (Function1)new Serializable(indices, alias, removePrevious, timeout){
            private static final long serialVersionUID = 0L;
            private final Iterable indices$1;
            private final String alias$2;
            private final boolean removePrevious$1;
            private final TimeValue timeout$2;

            public final AcknowledgedResponse apply(IndicesClient client) {
                return IndexAdmin$.MODULE$.com$spotify$scio$elasticsearch$IndexAdmin$$createOrUpdateAlias(client, (Iterable<Tuple2<String, Object>>)this.indices$1, this.alias$2, this.removePrevious$1, this.timeout$2);
            }
            {
                this.indices$1 = indices$1;
                this.alias$2 = alias$2;
                this.removePrevious$1 = removePrevious$1;
                this.timeout$2 = timeout$2;
            }
        });
    }

    private IndexAdmin$() {
    }
}

