/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.match;

import com.spotify.dataenum.function.Function;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.generator.match.TypeVariableUtils;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import javax.annotation.Nonnull;
import javax.lang.model.element.Modifier;

public class MapMethods {
    private static final TypeVariableName FOLD_RETURN_TYPE = TypeVariableName.get((String)"R_");
    private final Iterable<OutputValue> values;

    public MapMethods(Iterable<OutputValue> values) {
        this.values = values;
    }

    private MethodSpec.Builder createFoldSignature(Iterable<TypeVariableName> availableTypeVariables) throws ParserException {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"map").addTypeVariable(FOLD_RETURN_TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)FOLD_RETURN_TYPE);
        for (OutputValue arg : this.values) {
            ParameterizedTypeName visitor = ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{TypeVariableUtils.withoutMissingTypeVariables(arg.parameterizedOutputClass(), availableTypeVariables), FOLD_RETURN_TYPE});
            builder.addParameter(ParameterSpec.builder((TypeName)visitor, (String)MapMethods.asCamelCase(arg.name()), (Modifier[])new Modifier[0]).addAnnotation(Nonnull.class).build());
        }
        return builder;
    }

    public MethodSpec createAbstractFoldMethod() throws ParserException {
        return this.createFoldSignature(null).addModifiers(new Modifier[]{Modifier.ABSTRACT}).build();
    }

    public MethodSpec createFoldMethod(OutputValue value) throws ParserException {
        MethodSpec.Builder builder = this.createFoldSignature(value.typeVariables()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.FINAL});
        builder.addStatement("return $L.apply(this)", new Object[]{MapMethods.asCamelCase(value.name())});
        return builder.build();
    }

    private static String asCamelCase(String text) {
        return Character.toLowerCase(text.charAt(0)) + text.substring(1);
    }
}

