/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenum.processor.generator.data;

import com.spotify.dataenum.processor.data.OutputSpec;
import com.spotify.dataenum.processor.data.OutputValue;
import com.spotify.dataenum.processor.data.Spec;
import com.spotify.dataenum.processor.data.Value;
import com.spotify.dataenum.processor.generator.data.OutputValueFactory;
import com.spotify.dataenum.processor.parser.ParserException;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;

public final class OutputSpecFactory {
    private static final String SUFFIX = "_dataenum";

    private OutputSpecFactory() {
    }

    public static OutputSpec create(Spec spec) throws ParserException {
        ClassName specClass = spec.specClass();
        ClassName outputClass = OutputSpecFactory.toOutputClassName(specClass);
        ArrayList<OutputValue> values = new ArrayList<OutputValue>();
        for (Value value : spec.values()) {
            values.add(OutputValueFactory.create(value, outputClass, spec));
        }
        return new OutputSpec(spec, outputClass, values);
    }

    static boolean isSpecClassName(ClassName specClassName) {
        return specClassName.simpleName().endsWith(SUFFIX);
    }

    static ClassName toOutputClassName(ClassName specClassName) throws ParserException {
        String packageName = specClassName.packageName();
        String name = specClassName.simpleName();
        if (!OutputSpecFactory.isSpecClassName(specClassName)) {
            throw new ParserException(String.format("Bad name for DataEnum interface! Name must end with '%s', found: %s", SUFFIX, name));
        }
        String nameWithoutSuffix = name.substring(0, name.length() - SUFFIX.length());
        return ClassName.get((String)packageName, (String)nameWithoutSuffix, (String[])new String[0]);
    }
}

