/*
 * -\-\-
 * DataEnum
 * --
 * Copyright (c) 2017 Spotify AB
 * --
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * -/-/-
 */
package com.spotify.dataenim.apicompat;

import com.spotify.dataenim.apicompat.subpackage.Other_dataenum;
import com.spotify.dataenum.DataEnum;
import com.spotify.dataenum.dataenum_case;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

/** Starting point for dataenum API compatibility tests. */
@DataEnum
public interface MostThings_dataenum<T> {
  dataenum_case SimpleTypes(String s, Integer i, int unboxed);

  dataenum_case Collections(Set<String> set, List<Boolean> list);

  dataenum_case TypeParameter(T thing);

  dataenum_case ReferencesOther(Other_dataenum other);

  dataenum_case NullableParameter(@Nullable String maybeNull);
}
