package com.spotify.dataenim.apicompat;

import static com.spotify.dataenum.DataenumUtils.checkNotNull;
import static com.spotify.dataenum.DataenumUtils.equal;

import com.spotify.dataenim.apicompat.subpackage.Other;
import com.spotify.dataenum.function.Consumer;
import com.spotify.dataenum.function.Function;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.List;
import java.util.Set;
import javax.annotation.Generated;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Generated("com.spotify.dataenum.processor.DataEnumProcessor")
public abstract class MostThings<T> {
  MostThings() {
  }

  public static <T> MostThings<T> simpleTypes(@Nonnull String s, @Nonnull Integer i, int unboxed) {
    return new SimpleTypes(s, i, unboxed).asMostThings();
  }

  public static <T> MostThings<T> collections(@Nonnull Set<String> set,
      @Nonnull List<Boolean> list) {
    return new Collections(set, list).asMostThings();
  }

  public static <T> MostThings<T> typeParameter(@Nonnull T thing) {
    return new TypeParameter<T>(thing).asMostThings();
  }

  public static <T> MostThings<T> referencesOther(@Nonnull Other other) {
    return new ReferencesOther(other).asMostThings();
  }

  public static <T> MostThings<T> nullableParameter(@Nullable String maybeNull) {
    return new NullableParameter(maybeNull).asMostThings();
  }

  public final boolean isSimpleTypes() {
    return (this instanceof SimpleTypes);
  }

  public final boolean isCollections() {
    return (this instanceof Collections);
  }

  public final boolean isTypeParameter() {
    return (this instanceof TypeParameter);
  }

  public final boolean isReferencesOther() {
    return (this instanceof ReferencesOther);
  }

  public final boolean isNullableParameter() {
    return (this instanceof NullableParameter);
  }

  public final SimpleTypes asSimpleTypes() {
    return (SimpleTypes) this;
  }

  public final Collections asCollections() {
    return (Collections) this;
  }

  public final TypeParameter<T> asTypeParameter() {
    return (TypeParameter<T>) this;
  }

  public final ReferencesOther asReferencesOther() {
    return (ReferencesOther) this;
  }

  public final NullableParameter asNullableParameter() {
    return (NullableParameter) this;
  }

  public abstract void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
      @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<T>> typeParameter,
      @Nonnull Consumer<ReferencesOther> referencesOther,
      @Nonnull Consumer<NullableParameter> nullableParameter);

  public abstract <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
      @Nonnull Function<Collections, R_> collections,
      @Nonnull Function<TypeParameter<T>, R_> typeParameter,
      @Nonnull Function<ReferencesOther, R_> referencesOther,
      @Nonnull Function<NullableParameter, R_> nullableParameter);

  public static final class SimpleTypes extends MostThings<Object> {
    private final String s;

    private final Integer i;

    private final int unboxed;

    SimpleTypes(String s, Integer i, int unboxed) {
      this.s = checkNotNull(s);
      this.i = checkNotNull(i);
      this.unboxed = unboxed;
    }

    @Nonnull
    public final String s() {
      return s;
    }

    @Nonnull
    public final Integer i() {
      return i;
    }

    public final int unboxed() {
      return unboxed;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof SimpleTypes)) return false;
      SimpleTypes o = (SimpleTypes) other;
      return o.unboxed == unboxed
          && o.s.equals(this.s)
          && o.i.equals(this.i);
    }

    @Override
    public int hashCode() {
      int result = 0;
      result = result * 31 + s.hashCode();
      result = result * 31 + i.hashCode();
      return result * 31 + Integer.valueOf(unboxed).hashCode();
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append("SimpleTypes{s=").append(s);
      builder.append(", i=").append(i);
      builder.append(", unboxed=").append(unboxed);
      return builder.append('}').toString();
    }

    @Override
    public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
        @Nonnull Consumer<Collections> collections,
        @Nonnull Consumer<TypeParameter<Object>> typeParameter,
        @Nonnull Consumer<ReferencesOther> referencesOther,
        @Nonnull Consumer<NullableParameter> nullableParameter) {
      simpleTypes.accept(this);
    }

    @Override
    public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
        @Nonnull Function<Collections, R_> collections,
        @Nonnull Function<TypeParameter<Object>, R_> typeParameter,
        @Nonnull Function<ReferencesOther, R_> referencesOther,
        @Nonnull Function<NullableParameter, R_> nullableParameter) {
      return simpleTypes.apply(this);
    }

    @SuppressWarnings("unchecked")
    public final <T> MostThings<T> asMostThings() {
      return (MostThings<T>) this;
    }
  }

  public static final class Collections extends MostThings<Object> {
    private final Set<String> set;

    private final List<Boolean> list;

    Collections(Set<String> set, List<Boolean> list) {
      this.set = checkNotNull(set);
      this.list = checkNotNull(list);
    }

    @Nonnull
    public final Set<String> set() {
      return set;
    }

    @Nonnull
    public final List<Boolean> list() {
      return list;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof Collections)) return false;
      Collections o = (Collections) other;
      return o.set.equals(this.set)
          && o.list.equals(this.list);
    }

    @Override
    public int hashCode() {
      int result = 0;
      result = result * 31 + set.hashCode();
      return result * 31 + list.hashCode();
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append("Collections{set=").append(set);
      builder.append(", list=").append(list);
      return builder.append('}').toString();
    }

    @Override
    public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
        @Nonnull Consumer<Collections> collections,
        @Nonnull Consumer<TypeParameter<Object>> typeParameter,
        @Nonnull Consumer<ReferencesOther> referencesOther,
        @Nonnull Consumer<NullableParameter> nullableParameter) {
      collections.accept(this);
    }

    @Override
    public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
        @Nonnull Function<Collections, R_> collections,
        @Nonnull Function<TypeParameter<Object>, R_> typeParameter,
        @Nonnull Function<ReferencesOther, R_> referencesOther,
        @Nonnull Function<NullableParameter, R_> nullableParameter) {
      return collections.apply(this);
    }

    @SuppressWarnings("unchecked")
    public final <T> MostThings<T> asMostThings() {
      return (MostThings<T>) this;
    }
  }

  public static final class TypeParameter<T> extends MostThings<T> {
    private final T thing;

    TypeParameter(T thing) {
      this.thing = checkNotNull(thing);
    }

    @Nonnull
    public final T thing() {
      return thing;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof TypeParameter)) return false;
      TypeParameter<?> o = (TypeParameter<?>) other;
      return o.thing.equals(this.thing);
    }

    @Override
    public int hashCode() {
      int result = 0;
      return result * 31 + thing.hashCode();
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append("TypeParameter{thing=").append(thing);
      return builder.append('}').toString();
    }

    @Override
    public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
        @Nonnull Consumer<Collections> collections,
        @Nonnull Consumer<TypeParameter<T>> typeParameter,
        @Nonnull Consumer<ReferencesOther> referencesOther,
        @Nonnull Consumer<NullableParameter> nullableParameter) {
      typeParameter.accept(this);
    }

    @Override
    public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
        @Nonnull Function<Collections, R_> collections,
        @Nonnull Function<TypeParameter<T>, R_> typeParameter,
        @Nonnull Function<ReferencesOther, R_> referencesOther,
        @Nonnull Function<NullableParameter, R_> nullableParameter) {
      return typeParameter.apply(this);
    }

    public final MostThings<T> asMostThings() {
      return (MostThings<T>) this;
    }
  }

  public static final class ReferencesOther extends MostThings<Object> {
    private final Other other;

    ReferencesOther(Other other) {
      this.other = checkNotNull(other);
    }

    @Nonnull
    public final Other other() {
      return other;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof ReferencesOther)) return false;
      ReferencesOther o = (ReferencesOther) other;
      return o.other.equals(this.other);
    }

    @Override
    public int hashCode() {
      int result = 0;
      return result * 31 + other.hashCode();
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append("ReferencesOther{other=").append(other);
      return builder.append('}').toString();
    }

    @Override
    public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
        @Nonnull Consumer<Collections> collections,
        @Nonnull Consumer<TypeParameter<Object>> typeParameter,
        @Nonnull Consumer<ReferencesOther> referencesOther,
        @Nonnull Consumer<NullableParameter> nullableParameter) {
      referencesOther.accept(this);
    }

    @Override
    public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
        @Nonnull Function<Collections, R_> collections,
        @Nonnull Function<TypeParameter<Object>, R_> typeParameter,
        @Nonnull Function<ReferencesOther, R_> referencesOther,
        @Nonnull Function<NullableParameter, R_> nullableParameter) {
      return referencesOther.apply(this);
    }

    @SuppressWarnings("unchecked")
    public final <T> MostThings<T> asMostThings() {
      return (MostThings<T>) this;
    }
  }

  public static final class NullableParameter extends MostThings<Object> {
    private final String maybeNull;

    NullableParameter(String maybeNull) {
      this.maybeNull = maybeNull;
    }

    @Nullable
    public final String maybeNull() {
      return maybeNull;
    }

    @Override
    public boolean equals(Object other) {
      if (other == this) return true;
      if (!(other instanceof NullableParameter)) return false;
      NullableParameter o = (NullableParameter) other;
      return equal(o.maybeNull, this.maybeNull);
    }

    @Override
    public int hashCode() {
      int result = 0;
      return result * 31 + (maybeNull != null ? maybeNull.hashCode() : 0);
    }

    @Override
    public String toString() {
      StringBuilder builder = new StringBuilder();
      builder.append("NullableParameter{maybeNull=").append(maybeNull);
      return builder.append('}').toString();
    }

    @Override
    public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes,
        @Nonnull Consumer<Collections> collections,
        @Nonnull Consumer<TypeParameter<Object>> typeParameter,
        @Nonnull Consumer<ReferencesOther> referencesOther,
        @Nonnull Consumer<NullableParameter> nullableParameter) {
      nullableParameter.accept(this);
    }

    @Override
    public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes,
        @Nonnull Function<Collections, R_> collections,
        @Nonnull Function<TypeParameter<Object>, R_> typeParameter,
        @Nonnull Function<ReferencesOther, R_> referencesOther,
        @Nonnull Function<NullableParameter, R_> nullableParameter) {
      return nullableParameter.apply(this);
    }

    @SuppressWarnings("unchecked")
    public final <T> MostThings<T> asMostThings() {
      return (MostThings<T>) this;
    }
  }
}
