/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.dataenim.apicompat;

import com.spotify.dataenim.apicompat.subpackage.Other;
import com.spotify.dataenum.DataenumUtils;
import com.spotify.dataenum.function.Consumer;
import com.spotify.dataenum.function.Function;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class MostThings<T> {
    MostThings() {
    }

    public static <T> MostThings<T> simpleTypes(@Nonnull String s, @Nonnull Integer i, int unboxed) {
        return new SimpleTypes(s, i, unboxed).asMostThings();
    }

    public static <T> MostThings<T> collections(@Nonnull Set<String> set, @Nonnull List<Boolean> list) {
        return new Collections(set, list).asMostThings();
    }

    public static <T> MostThings<T> typeParameter(@Nonnull T thing) {
        return new TypeParameter<T>(thing).asMostThings();
    }

    public static <T> MostThings<T> referencesOther(@Nonnull Other other) {
        return new ReferencesOther(other).asMostThings();
    }

    public static <T> MostThings<T> nullableParameter(@Nullable String maybeNull) {
        return new NullableParameter(maybeNull).asMostThings();
    }

    public final boolean isSimpleTypes() {
        return this instanceof SimpleTypes;
    }

    public final boolean isCollections() {
        return this instanceof Collections;
    }

    public final boolean isTypeParameter() {
        return this instanceof TypeParameter;
    }

    public final boolean isReferencesOther() {
        return this instanceof ReferencesOther;
    }

    public final boolean isNullableParameter() {
        return this instanceof NullableParameter;
    }

    public final SimpleTypes asSimpleTypes() {
        return (SimpleTypes)this;
    }

    public final Collections asCollections() {
        return (Collections)this;
    }

    public final TypeParameter<T> asTypeParameter() {
        return (TypeParameter)this;
    }

    public final ReferencesOther asReferencesOther() {
        return (ReferencesOther)this;
    }

    public final NullableParameter asNullableParameter() {
        return (NullableParameter)this;
    }

    public abstract void match(@Nonnull Consumer<SimpleTypes> var1, @Nonnull Consumer<Collections> var2, @Nonnull Consumer<TypeParameter<T>> var3, @Nonnull Consumer<ReferencesOther> var4, @Nonnull Consumer<NullableParameter> var5);

    public abstract <R_> R_ map(@Nonnull Function<SimpleTypes, R_> var1, @Nonnull Function<Collections, R_> var2, @Nonnull Function<TypeParameter<T>, R_> var3, @Nonnull Function<ReferencesOther, R_> var4, @Nonnull Function<NullableParameter, R_> var5);

    public static final class NullableParameter
    extends MostThings<Object> {
        private final String maybeNull;

        NullableParameter(String maybeNull) {
            this.maybeNull = maybeNull;
        }

        @Nullable
        public final String maybeNull() {
            return this.maybeNull;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof NullableParameter)) {
                return false;
            }
            NullableParameter o = (NullableParameter)other;
            return DataenumUtils.equal((Object)o.maybeNull, (Object)this.maybeNull);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + (this.maybeNull != null ? this.maybeNull.hashCode() : 0);
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("NullableParameter{maybeNull=").append(this.maybeNull);
            return builder.append('}').toString();
        }

        @Override
        public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes, @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<Object>> typeParameter, @Nonnull Consumer<ReferencesOther> referencesOther, @Nonnull Consumer<NullableParameter> nullableParameter) {
            nullableParameter.accept((Object)this);
        }

        @Override
        public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes, @Nonnull Function<Collections, R_> collections, @Nonnull Function<TypeParameter<Object>, R_> typeParameter, @Nonnull Function<ReferencesOther, R_> referencesOther, @Nonnull Function<NullableParameter, R_> nullableParameter) {
            return (R_)nullableParameter.apply((Object)this);
        }

        public final <T> MostThings<T> asMostThings() {
            return this;
        }
    }

    public static final class ReferencesOther
    extends MostThings<Object> {
        private final Other other;

        ReferencesOther(Other other) {
            this.other = (Other)DataenumUtils.checkNotNull((Object)other);
        }

        @Nonnull
        public final Other other() {
            return this.other;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ReferencesOther)) {
                return false;
            }
            ReferencesOther o = (ReferencesOther)other;
            return o.other.equals(this.other);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.other.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ReferencesOther{other=").append(this.other);
            return builder.append('}').toString();
        }

        @Override
        public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes, @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<Object>> typeParameter, @Nonnull Consumer<ReferencesOther> referencesOther, @Nonnull Consumer<NullableParameter> nullableParameter) {
            referencesOther.accept((Object)this);
        }

        @Override
        public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes, @Nonnull Function<Collections, R_> collections, @Nonnull Function<TypeParameter<Object>, R_> typeParameter, @Nonnull Function<ReferencesOther, R_> referencesOther, @Nonnull Function<NullableParameter, R_> nullableParameter) {
            return (R_)referencesOther.apply((Object)this);
        }

        public final <T> MostThings<T> asMostThings() {
            return this;
        }
    }

    public static final class TypeParameter<T>
    extends MostThings<T> {
        private final T thing;

        TypeParameter(T thing) {
            this.thing = DataenumUtils.checkNotNull(thing);
        }

        @Nonnull
        public final T thing() {
            return this.thing;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof TypeParameter)) {
                return false;
            }
            TypeParameter o = (TypeParameter)other;
            return o.thing.equals(this.thing);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.thing.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("TypeParameter{thing=").append(this.thing);
            return builder.append('}').toString();
        }

        @Override
        public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes, @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<T>> typeParameter, @Nonnull Consumer<ReferencesOther> referencesOther, @Nonnull Consumer<NullableParameter> nullableParameter) {
            typeParameter.accept((Object)this);
        }

        @Override
        public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes, @Nonnull Function<Collections, R_> collections, @Nonnull Function<TypeParameter<T>, R_> typeParameter, @Nonnull Function<ReferencesOther, R_> referencesOther, @Nonnull Function<NullableParameter, R_> nullableParameter) {
            return (R_)typeParameter.apply((Object)this);
        }

        public final MostThings<T> asMostThings() {
            return this;
        }
    }

    public static final class Collections
    extends MostThings<Object> {
        private final Set<String> set;
        private final List<Boolean> list;

        Collections(Set<String> set, List<Boolean> list) {
            this.set = (Set)DataenumUtils.checkNotNull(set);
            this.list = (List)DataenumUtils.checkNotNull(list);
        }

        @Nonnull
        public final Set<String> set() {
            return this.set;
        }

        @Nonnull
        public final List<Boolean> list() {
            return this.list;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Collections)) {
                return false;
            }
            Collections o = (Collections)other;
            return o.set.equals(this.set) && o.list.equals(this.list);
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.set.hashCode();
            result = result * 31 + this.list.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Collections{set=").append(this.set);
            builder.append(", list=").append(this.list);
            return builder.append('}').toString();
        }

        @Override
        public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes, @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<Object>> typeParameter, @Nonnull Consumer<ReferencesOther> referencesOther, @Nonnull Consumer<NullableParameter> nullableParameter) {
            collections.accept((Object)this);
        }

        @Override
        public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes, @Nonnull Function<Collections, R_> collections, @Nonnull Function<TypeParameter<Object>, R_> typeParameter, @Nonnull Function<ReferencesOther, R_> referencesOther, @Nonnull Function<NullableParameter, R_> nullableParameter) {
            return (R_)collections.apply((Object)this);
        }

        public final <T> MostThings<T> asMostThings() {
            return this;
        }
    }

    public static final class SimpleTypes
    extends MostThings<Object> {
        private final String s;
        private final Integer i;
        private final int unboxed;

        SimpleTypes(String s, Integer i, int unboxed) {
            this.s = (String)DataenumUtils.checkNotNull((Object)s);
            this.i = (Integer)DataenumUtils.checkNotNull((Object)i);
            this.unboxed = unboxed;
        }

        @Nonnull
        public final String s() {
            return this.s;
        }

        @Nonnull
        public final Integer i() {
            return this.i;
        }

        public final int unboxed() {
            return this.unboxed;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof SimpleTypes)) {
                return false;
            }
            SimpleTypes o = (SimpleTypes)other;
            return o.s.equals(this.s) && o.i.equals(this.i) && o.unboxed == this.unboxed;
        }

        public int hashCode() {
            int result = 0;
            result = result * 31 + this.s.hashCode();
            result = result * 31 + this.i.hashCode();
            result = result * 31 + Integer.valueOf(this.unboxed).hashCode();
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SimpleTypes{s=").append(this.s);
            builder.append(", i=").append(this.i);
            builder.append(", unboxed=").append(this.unboxed);
            return builder.append('}').toString();
        }

        @Override
        public final void match(@Nonnull Consumer<SimpleTypes> simpleTypes, @Nonnull Consumer<Collections> collections, @Nonnull Consumer<TypeParameter<Object>> typeParameter, @Nonnull Consumer<ReferencesOther> referencesOther, @Nonnull Consumer<NullableParameter> nullableParameter) {
            simpleTypes.accept((Object)this);
        }

        @Override
        public final <R_> R_ map(@Nonnull Function<SimpleTypes, R_> simpleTypes, @Nonnull Function<Collections, R_> collections, @Nonnull Function<TypeParameter<Object>, R_> typeParameter, @Nonnull Function<ReferencesOther, R_> referencesOther, @Nonnull Function<NullableParameter, R_> nullableParameter) {
            return (R_)simpleTypes.apply((Object)this);
        }

        public final <T> MostThings<T> asMostThings() {
            return this;
        }
    }
}

