/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.name.Names;
import com.spotify.apollo.core.Service;
import com.spotify.apollo.http.server.HttpServer;
import com.spotify.apollo.http.server.HttpServerConfig;
import com.spotify.apollo.http.server.HttpServerProvider;
import com.spotify.apollo.module.AbstractApolloModule;
import java.lang.annotation.Annotation;
import java.util.Objects;
import javax.inject.Singleton;

public class HttpServerModule
extends AbstractApolloModule {
    private final Runnable onClose;

    private HttpServerModule(Runnable onClose) {
        this.onClose = Objects.requireNonNull(onClose);
    }

    public static HttpServerModule create() {
        return new HttpServerModule(() -> {});
    }

    @VisibleForTesting
    static HttpServerModule createForTest(Runnable onClose) {
        return new HttpServerModule(onClose);
    }

    protected void configure() {
        this.bind(HttpServerConfig.class);
        this.bind(Runnable.class).annotatedWith((Annotation)Names.named((String)"http-server-on-close")).toInstance((Object)this.onClose);
        this.bind(HttpServer.class).toProvider(HttpServerProvider.class).in(Singleton.class);
    }

    public String getId() {
        return "http.server";
    }

    public double getPriority() {
        return -128.0;
    }

    public static HttpServer server(Service.Instance instance) {
        return (HttpServer)instance.resolve(HttpServer.class);
    }
}

