/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.spotify.apollo.environment.ConfigUtil;
import com.typesafe.config.Config;
import javax.inject.Inject;

class HttpServerConfig {
    private static final String CONFIG_BASE_NAME = "http.server";
    private static final String DEFAULT_HTTP_ADDRESS = "0.0.0.0";
    private static final int DEFAULT_TTL_MILLIS = 30000;
    private final Config config;

    @Inject
    HttpServerConfig(Config config) {
        this.config = config;
    }

    public String address() {
        return ConfigUtil.optionalString((Config)this.config, (String)"http.server.address").orElse(DEFAULT_HTTP_ADDRESS);
    }

    public Integer port() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.port").orElse(null);
    }

    public long ttlMillis() {
        return ConfigUtil.optionalInt((Config)this.config, (String)"http.server.ttlMillis").orElse(30000).intValue();
    }
}

