/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.spotify.apollo.http.server.RequestOutcomeConsumer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CombinedFormatLogger {
    private static final Logger LOGGER = LoggerFactory.getLogger(CombinedFormatLogger.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendLiteral("[").appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('/').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, TextStyle.SHORT).appendLiteral('/').appendValue(ChronoField.YEAR, 4).appendLiteral(':').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendOffset("+HHMM", "UTC").appendLiteral(']').toFormatter(Locale.ENGLISH);
    private static final RequestOutcomeConsumer LOG_WITH_COMBINED_FORMAT = (ongoingRequest, response) -> LOGGER.info("- - - {} \"{}\" {} {} \"{}\" \"{}\"", new Object[]{DATE_TIME_FORMATTER.format(ZonedDateTime.now()), String.format("%s %s", ongoingRequest.request().method(), ongoingRequest.request().uri()), response.map(r -> String.valueOf(r.status().code())).orElse("-"), response.flatMap(r -> r.payload().map(p -> String.valueOf(p.size()))).orElse("-"), ongoingRequest.request().header("Referer").orElse("-"), ongoingRequest.request().header("User-Agent").orElse("-")});

    private CombinedFormatLogger() {
    }

    static RequestOutcomeConsumer logger() {
        return LOG_WITH_COMBINED_FORMAT;
    }
}

