/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.spotify.apollo.Request;
import com.spotify.apollo.RequestMetadata;
import com.spotify.apollo.Response;
import com.spotify.apollo.Status;
import com.spotify.apollo.StatusType;
import com.spotify.apollo.http.server.RequestOutcomeConsumer;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.ServerInfo;
import com.spotify.apollo.request.ServerInfos;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletResponse;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AsyncContextOngoingRequest
implements OngoingRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncContextOngoingRequest.class);
    private final Request request;
    private final AsyncContext asyncContext;
    private final RequestOutcomeConsumer logger;
    private final AtomicBoolean replied = new AtomicBoolean(false);
    private final RequestMetadata metadata;

    AsyncContextOngoingRequest(Request request, AsyncContext asyncContext, RequestOutcomeConsumer logger, RequestMetadata metadata) {
        this.request = Objects.requireNonNull(request);
        this.asyncContext = Objects.requireNonNull(asyncContext);
        this.logger = Objects.requireNonNull(logger);
        this.metadata = Objects.requireNonNull(metadata);
    }

    public Request request() {
        return this.request;
    }

    public void reply(Response<ByteString> response) {
        this.sendReply(response);
    }

    public void drop() {
        this.sendReply((Response<ByteString>)Response.forStatus((StatusType)Status.INTERNAL_SERVER_ERROR.withReasonPhrase("dropped")));
    }

    private void sendReply(Response<ByteString> response) {
        if (!this.replied.compareAndSet(false, true)) {
            LOGGER.warn("Already replied to ongoing request {} - spurious response {}", (Object)this.request, response);
        } else {
            HttpServletResponse httpResponse = (HttpServletResponse)this.asyncContext.getResponse();
            StatusType status = response.status();
            httpResponse.setStatus(status.code(), status.reasonPhrase());
            response.headers().forEach((arg_0, arg_1) -> ((HttpServletResponse)httpResponse).addHeader(arg_0, arg_1));
            response.payload().ifPresent(payload -> {
                try {
                    payload.write((OutputStream)httpResponse.getOutputStream());
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to write response", (Throwable)e);
                }
            });
            this.asyncContext.complete();
            this.logger.accept(this, Optional.of(response));
        }
    }

    public boolean isExpired() {
        return false;
    }

    public ServerInfo serverInfo() {
        return ServerInfos.create((String)"http", (InetSocketAddress)this.toSocketAddress(this.metadata.localAddress()));
    }

    private InetSocketAddress toSocketAddress(Optional<RequestMetadata.HostAndPort> hostAndPort) {
        return hostAndPort.map(hp -> InetSocketAddress.createUnresolved(hp.host(), hp.port())).orElse(PORT_ZERO);
    }

    public RequestMetadata metadata() {
        return this.metadata;
    }
}

