/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.apollo.http.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.spotify.apollo.Request;
import com.spotify.apollo.RequestMetadata;
import com.spotify.apollo.http.server.AsyncContextOngoingRequest;
import com.spotify.apollo.http.server.HttpRequestMetadata;
import com.spotify.apollo.http.server.RequestOutcomeConsumer;
import com.spotify.apollo.http.server.TimeoutListener;
import com.spotify.apollo.request.OngoingRequest;
import com.spotify.apollo.request.RequestHandler;
import com.spotify.apollo.request.RequestMetadataImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import okio.ByteString;
import org.eclipse.jetty.server.handler.AbstractHandler;

class ApolloRequestHandler
extends AbstractHandler {
    private final RequestHandler requestHandler;
    private final RequestMetadata.HostAndPort serverInfo;
    private final Duration requestTimeout;
    private final RequestOutcomeConsumer logger;

    ApolloRequestHandler(RequestMetadata.HostAndPort serverInfo, RequestHandler requestHandler, Duration requestTimeout, RequestOutcomeConsumer logger) {
        this.requestHandler = Objects.requireNonNull(requestHandler);
        this.serverInfo = Objects.requireNonNull(serverInfo);
        this.requestTimeout = Objects.requireNonNull(requestTimeout);
        this.logger = Objects.requireNonNull(logger);
    }

    public void handle(String target, org.eclipse.jetty.server.Request baseRequest, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AsyncContext asyncContext = baseRequest.startAsync();
        RequestMetadata metadata = this.extractMetadata(req);
        AsyncContextOngoingRequest ongoingRequest = new AsyncContextOngoingRequest(this.asApolloRequest(req), asyncContext, this.logger, metadata);
        asyncContext.setTimeout(this.requestTimeout.toMillis());
        asyncContext.addListener((AsyncListener)TimeoutListener.create(ongoingRequest));
        this.requestHandler.handle((OngoingRequest)ongoingRequest);
        baseRequest.setHandled(true);
    }

    private RequestMetadata extractMetadata(HttpServletRequest req) {
        return HttpRequestMetadata.create(Instant.now(), Optional.of(this.serverInfo), Optional.of(RequestMetadataImpl.hostAndPort((String)req.getRemoteHost(), (int)req.getRemotePort())), req.getProtocol());
    }

    @VisibleForTesting
    Request asApolloRequest(HttpServletRequest req) throws IOException {
        String uri = req.getRequestURI() + (req.getQueryString() == null ? "" : "?" + req.getQueryString());
        String method = req.getMethod();
        int contentLength = req.getContentLength();
        Optional payload = contentLength > -1 ? Optional.of(this.readPayload(req, contentLength)) : Optional.empty();
        ImmutableMap.Builder headersBuilder = ImmutableMap.builder();
        ApolloRequestHandler.toStream(req.getHeaderNames()).forEachOrdered(name -> headersBuilder.put(name, (Object)ApolloRequestHandler.toStream(req.getHeaders(name)).collect(Collectors.joining(","))));
        ImmutableMap headers = headersBuilder.build();
        Request result = Request.forUri((String)uri, (String)method).withHeaders((Map)headers);
        String callingService = (String)headers.get((Object)"X-Calling-Service");
        if (!Strings.isNullOrEmpty((String)callingService)) {
            result = result.withService(callingService);
        }
        if (payload.isPresent()) {
            result = result.withPayload((ByteString)payload.get());
        }
        return result;
    }

    private ByteString readPayload(HttpServletRequest req, int contentLength) throws IOException {
        BufferedInputStream input = new BufferedInputStream((InputStream)req.getInputStream());
        return ByteString.read((InputStream)input, (int)contentLength);
    }

    private static <T> Stream<T> toStream(Enumeration<T> enumeration) {
        ArrayList<T> list = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list.stream();
    }
}

