package com.spotify.apollo.http.server;

import com.spotify.apollo.RequestMetadata;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_HttpRequestMetadata extends HttpRequestMetadata {

  private final Instant arrivalTime;

  private final Optional<RequestMetadata.HostAndPort> localAddress;

  private final Optional<RequestMetadata.HostAndPort> remoteAddress;

  private final String httpVersion;

  AutoValue_HttpRequestMetadata(
      Instant arrivalTime,
      Optional<RequestMetadata.HostAndPort> localAddress,
      Optional<RequestMetadata.HostAndPort> remoteAddress,
      String httpVersion) {
    if (arrivalTime == null) {
      throw new NullPointerException("Null arrivalTime");
    }
    this.arrivalTime = arrivalTime;
    if (localAddress == null) {
      throw new NullPointerException("Null localAddress");
    }
    this.localAddress = localAddress;
    if (remoteAddress == null) {
      throw new NullPointerException("Null remoteAddress");
    }
    this.remoteAddress = remoteAddress;
    if (httpVersion == null) {
      throw new NullPointerException("Null httpVersion");
    }
    this.httpVersion = httpVersion;
  }

  @Override
  public Instant arrivalTime() {
    return arrivalTime;
  }

  @Override
  public Optional<RequestMetadata.HostAndPort> localAddress() {
    return localAddress;
  }

  @Override
  public Optional<RequestMetadata.HostAndPort> remoteAddress() {
    return remoteAddress;
  }

  @Override
  public String httpVersion() {
    return httpVersion;
  }

  @Override
  public String toString() {
    return "HttpRequestMetadata{"
         + "arrivalTime=" + arrivalTime + ", "
         + "localAddress=" + localAddress + ", "
         + "remoteAddress=" + remoteAddress + ", "
         + "httpVersion=" + httpVersion
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof HttpRequestMetadata) {
      HttpRequestMetadata that = (HttpRequestMetadata) o;
      return this.arrivalTime.equals(that.arrivalTime())
          && this.localAddress.equals(that.localAddress())
          && this.remoteAddress.equals(that.remoteAddress())
          && this.httpVersion.equals(that.httpVersion());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= arrivalTime.hashCode();
    h$ *= 1000003;
    h$ ^= localAddress.hashCode();
    h$ *= 1000003;
    h$ ^= remoteAddress.hashCode();
    h$ *= 1000003;
    h$ ^= httpVersion.hashCode();
    return h$;
  }

}
