/*
 * Decompiled with CFR 0.152.
 */
package sttp.client.okhttp.monix.internal;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.WebSocket;
import okio.ByteString;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import sttp.client.monad.MonadAsyncError;
import sttp.client.monad.MonadError;
import sttp.client.monad.syntax;
import sttp.client.monad.syntax$;
import sttp.client.okhttp.WebSocketHandler;
import sttp.client.okhttp.monix.internal.AddToQueueListener;
import sttp.client.ws.WebSocketEvent;
import sttp.client.ws.internal.AsyncQueue;
import sttp.model.ws.WebSocketClosed;
import sttp.model.ws.WebSocketFrame;

public final class NativeWebSocketHandler$ {
    public static final NativeWebSocketHandler$ MODULE$ = new NativeWebSocketHandler$();

    public <F> WebSocketHandler<sttp.client.ws.WebSocket<F>> apply(AsyncQueue<F, WebSocketEvent> queue, MonadAsyncError<F> monad) {
        AtomicBoolean isOpen = new AtomicBoolean(false);
        return new WebSocketHandler(new AddToQueueListener<F>(queue, isOpen), (Function1 & Serializable)x$1 -> MODULE$.httpClientWebSocketToWebSocket((WebSocket)x$1, queue, isOpen, monad));
    }

    private <F> sttp.client.ws.WebSocket<F> httpClientWebSocketToWebSocket(WebSocket ws, AsyncQueue<F, WebSocketEvent> queue, AtomicBoolean _isOpen, MonadAsyncError<F> _monad) {
        return new sttp.client.ws.WebSocket<F>(queue, ws, _monad, _isOpen){
            private final AsyncQueue queue$2;
            private final WebSocket ws$1;
            private final MonadAsyncError _monad$1;
            private final AtomicBoolean _isOpen$1;

            public F receiveDataFrame(boolean pongOnPing) {
                return (F)sttp.client.ws.WebSocket.receiveDataFrame$((sttp.client.ws.WebSocket)this, (boolean)pongOnPing);
            }

            public boolean receiveDataFrame$default$1() {
                return sttp.client.ws.WebSocket.receiveDataFrame$default$1$((sttp.client.ws.WebSocket)this);
            }

            public F receiveTextFrame(boolean pongOnPing) {
                return (F)sttp.client.ws.WebSocket.receiveTextFrame$((sttp.client.ws.WebSocket)this, (boolean)pongOnPing);
            }

            public boolean receiveTextFrame$default$1() {
                return sttp.client.ws.WebSocket.receiveTextFrame$default$1$((sttp.client.ws.WebSocket)this);
            }

            public F receiveBinaryFrame(boolean pongOnPing) {
                return (F)sttp.client.ws.WebSocket.receiveBinaryFrame$((sttp.client.ws.WebSocket)this, (boolean)pongOnPing);
            }

            public boolean receiveBinaryFrame$default$1() {
                return sttp.client.ws.WebSocket.receiveBinaryFrame$default$1$((sttp.client.ws.WebSocket)this);
            }

            public F receiveText(boolean pongOnPing) {
                return (F)sttp.client.ws.WebSocket.receiveText$((sttp.client.ws.WebSocket)this, (boolean)pongOnPing);
            }

            public boolean receiveText$default$1() {
                return sttp.client.ws.WebSocket.receiveText$default$1$((sttp.client.ws.WebSocket)this);
            }

            public F receiveBinary(boolean pongOnPing) {
                return (F)sttp.client.ws.WebSocket.receiveBinary$((sttp.client.ws.WebSocket)this, (boolean)pongOnPing);
            }

            public F close() {
                return (F)sttp.client.ws.WebSocket.close$((sttp.client.ws.WebSocket)this);
            }

            public F receive() {
                return (F)syntax.MonadErrorOps$.MODULE$.flatMap$extension(syntax$.MODULE$.MonadErrorOps(this.queue$2.poll()), (Function1 & Serializable)x0$1 -> {
                    void var2_9;
                    boolean bl = false;
                    WebSocketEvent.Error error = null;
                    WebSocketEvent webSocketEvent = x0$1;
                    if (webSocketEvent instanceof WebSocketEvent.Open) {
                        F f = this.receive();
                        return var2_9;
                    }
                    if (webSocketEvent instanceof WebSocketEvent.Close) {
                        WebSocketEvent.Close close = (WebSocketEvent.Close)webSocketEvent;
                        $this.queue$2.offer((Object)new WebSocketEvent.Error((Throwable)new WebSocketClosed()));
                        Object object = this.monad().unit((Object)package$.MODULE$.Left().apply((Object)close));
                        return var2_9;
                    }
                    if (webSocketEvent instanceof WebSocketEvent.Error) {
                        bl = true;
                        error = (WebSocketEvent.Error)webSocketEvent;
                        Throwable t = error.t();
                        if (t instanceof Exception) {
                            Exception exception = (Exception)t;
                            $this.queue$2.offer((Object)error);
                            Object object = this.monad().error((Throwable)exception);
                            return var2_9;
                        }
                    }
                    if (bl) {
                        Throwable t = error.t();
                        throw t;
                    }
                    if (!(webSocketEvent instanceof WebSocketEvent.Frame)) throw new MatchError((Object)webSocketEvent);
                    WebSocketEvent.Frame frame = (WebSocketEvent.Frame)webSocketEvent;
                    WebSocketFrame.Incoming f = frame.f();
                    Object object = this.monad().unit((Object)package$.MODULE$.Right().apply((Object)f));
                    return var2_9;
                }, this.monad());
            }

            public F send(WebSocketFrame f, boolean isContinuation) {
                return (F)this.monad().flatten(this.monad().eval((Function0 & Serializable)() -> {
                    Object object;
                    WebSocketFrame webSocketFrame = f;
                    if (webSocketFrame instanceof WebSocketFrame.Text) {
                        WebSocketFrame.Text text = (WebSocketFrame.Text)webSocketFrame;
                        String payload = text.payload();
                        boolean bool = $this.ws$1.send(payload);
                        object = this.fromBoolean(bool);
                    } else if (webSocketFrame instanceof WebSocketFrame.Binary) {
                        WebSocketFrame.Binary binary = (WebSocketFrame.Binary)webSocketFrame;
                        byte[] payload = binary.payload();
                        object = this.fromBoolean($this.ws$1.send(new ByteString(payload)));
                    } else if (webSocketFrame instanceof WebSocketFrame.Close) {
                        String reasonText;
                        WebSocketFrame.Close close = (WebSocketFrame.Close)webSocketFrame;
                        int statusCode = close.statusCode();
                        object = $this.ws$1.close(statusCode, reasonText = close.reasonText()) ? $this._monad$1.unit((Object)BoxedUnit.UNIT) : $this._monad$1.error((Throwable)new WebSocketClosed());
                    } else if (webSocketFrame instanceof WebSocketFrame.Ping) {
                        object = $this._monad$1.error((Throwable)new UnsupportedOperationException("Ping is handled by okhttp under the hood"));
                    } else if (webSocketFrame instanceof WebSocketFrame.Pong) {
                        object = $this._monad$1.error((Throwable)new UnsupportedOperationException("Pong is handled by okhttp under the hood"));
                    } else {
                        throw new MatchError((Object)webSocketFrame);
                    }
                    return object;
                }));
            }

            public boolean send$default$2() {
                return false;
            }

            public F isOpen() {
                return (F)this.monad().eval((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this._isOpen$1.get());
            }

            public MonadError<F> monad() {
                return this._monad$1;
            }

            private F fromBoolean(boolean result) {
                return (F)(!result ? this._monad$1.error((Throwable)new RuntimeException("Cannot enqueue next message. Socket is closed, closing or cancelled or this message would overflow the outgoing message buffer (16M MiB)")) : this.monad().unit((Object)BoxedUnit.UNIT));
            }
            {
                this.queue$2 = queue$2;
                this.ws$1 = ws$1;
                this._monad$1 = _monad$1;
                this._isOpen$1 = _isOpen$1;
                sttp.client.ws.WebSocket.$init$((sttp.client.ws.WebSocket)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$isOpen$1(sttp.client.okhttp.monix.internal.NativeWebSocketHandler$$anon$1 ), $anonfun$receive$1(sttp.client.okhttp.monix.internal.NativeWebSocketHandler$$anon$1 sttp.client.ws.WebSocketEvent ), $anonfun$send$1(sttp.client.okhttp.monix.internal.NativeWebSocketHandler$$anon$1 sttp.model.ws.WebSocketFrame )}, serializedLambda);
            }
        };
    }

    private NativeWebSocketHandler$() {
    }
}

