/*
 * Decompiled with CFR 0.152.
 */
package sttp.client.okhttp.monix.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;
import sttp.client.ws.WebSocketEvent;
import sttp.client.ws.internal.AsyncQueue;
import sttp.model.ws.WebSocketFrame;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0006\r\t]A\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0011\n\u0001C\u0001\u0015\")q\n\u0001C!!\")1\u000e\u0001C!Y\")\u0001\u000f\u0001C!c\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0003\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\u0011!#\u00113e)>\fV/Z;f\u0019&\u001cH/\u001a8fe*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\u0006[>t\u0017\u000e\u001f\u0006\u0003#I\taa\\6iiR\u0004(BA\n\u0015\u0003\u0019\u0019G.[3oi*\tQ#\u0001\u0003tiR\u00048\u0001A\u000b\u00031%\u001a\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tqa\\6iiR\u00048'\u0003\u0002\u001f7\t\tr+\u001a2T_\u000e\\W\r\u001e'jgR,g.\u001a:\u0002\u000bE,X-^3\u0011\t\u0005*s\u0005O\u0007\u0002E)\u0011Qb\t\u0006\u0003II\t!a^:\n\u0005\u0019\u0012#AC!ts:\u001c\u0017+^3vKB\u0011\u0001&\u000b\u0007\u0001\t\u0015Q\u0003A1\u0001,\u0005\u00051UC\u0001\u00177#\ti3\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tFA\u0004O_RD\u0017N\\4\u0011\u00059\"\u0014BA\u001b0\u0005\r\te.\u001f\u0003\u0006o%\u0012\r\u0001\f\u0002\u0002?B\u0011\u0011HO\u0007\u0002G%\u00111h\t\u0002\u000f/\u0016\u00147k\\2lKR,e/\u001a8u\u0003\u0019I7o\u00149f]B\u0011ahR\u0007\u0002\u007f)\u0011\u0001)Q\u0001\u0007CR|W.[2\u000b\u0005\t\u001b\u0015AC2p]\u000e,(O]3oi*\u0011A)R\u0001\u0005kRLGNC\u0001G\u0003\u0011Q\u0017M^1\n\u0005!{$!D!u_6L7MQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\u0004\u00176s\u0005c\u0001'\u0001O5\tA\u0002C\u0003 \u0007\u0001\u0007\u0001\u0005C\u0003=\u0007\u0001\u0007Q(\u0001\u0005p]\u000ecwn]3e)\u0011\tF+\u00170\u0011\u00059\u0012\u0016BA*0\u0005\u0011)f.\u001b;\t\u000bU#\u0001\u0019\u0001,\u0002\u0013],'mU8dW\u0016$\bC\u0001\u000eX\u0013\tA6DA\u0005XK\n\u001cvnY6fi\")!\f\u0002a\u00017\u0006!1m\u001c3f!\tqC,\u0003\u0002^_\t\u0019\u0011J\u001c;\t\u000b}#\u0001\u0019\u00011\u0002\rI,\u0017m]8o!\t\t\u0007N\u0004\u0002cMB\u00111mL\u0007\u0002I*\u0011QMF\u0001\u0007yI|w\u000e\u001e \n\u0005\u001d|\u0013A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ\u0018\u0002\u0013=t7\t\\8tS:<G\u0003B)n]>DQ!V\u0003A\u0002YCQAW\u0003A\u0002mCQaX\u0003A\u0002\u0001\f\u0011b\u001c8GC&dWO]3\u0015\tE\u00138O \u0005\u0006+\u001a\u0001\rA\u0016\u0005\u0006i\u001a\u0001\r!^\u0001\u0002iB\u0011ao\u001f\b\u0003oft!a\u0019=\n\u0003AJ!A_\u0018\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\n)\"\u0014xn^1cY\u0016T!A_\u0018\t\r}4\u0001\u0019AA\u0001\u0003!\u0011Xm\u001d9p]N,\u0007c\u0001\u000e\u0002\u0004%\u0019\u0011QA\u000e\u0003\u0011I+7\u000f]8og\u0016\f\u0011b\u001c8NKN\u001c\u0018mZ3\u0015\u000bE\u000bY!!\u0004\t\u000bU;\u0001\u0019\u0001,\t\r\u0005=q\u00011\u0001a\u0003\u0011!X\r\u001f;\u0015\u000bE\u000b\u0019\"!\u0006\t\u000bUC\u0001\u0019\u0001,\t\u000f\u0005]\u0001\u00021\u0001\u0002\u001a\u0005)!-\u001f;fgB!\u00111DA\u0011\u001b\t\tiB\u0003\u0002\u0002 \u0005!qn[5p\u0013\u0011\t\u0019#!\b\u0003\u0015\tKH/Z*ue&tw-\u0001\u0004p]>\u0003XM\u001c\u000b\u0006#\u0006%\u00121\u0006\u0005\u0006+&\u0001\rA\u0016\u0005\u0007\u007f&\u0001\r!!\u0001\u0002\u000f=tgI]1nKR\u0019\u0011+!\r\t\u000f\u0005M\"\u00021\u0001\u00026\u0005\ta\r\u0005\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u0003j!!a\u000f\u000b\u0007\u0011\niDC\u0002\u0002@Q\tQ!\\8eK2LA!a\u0011\u0002<\u0005qq+\u001a2T_\u000e\\W\r\u001e$sC6,\u0017\u0002BA$\u0003\u0013\u0012\u0001\"\u00138d_6Lgn\u001a\u0006\u0005\u0003\u0007\nY\u0004")
public class AddToQueueListener<F>
extends WebSocketListener {
    private final AsyncQueue<F, WebSocketEvent> queue;
    private final AtomicBoolean isOpen;

    public void onClosed(WebSocket webSocket, int code, String reason) {
        this.isOpen.set(false);
        this.queue.offer((Object)new WebSocketEvent.Close(code, reason));
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.isOpen.set(false);
        this.queue.offer((Object)new WebSocketEvent.Close(code, reason));
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        this.isOpen.set(false);
        this.queue.offer((Object)new WebSocketEvent.Error(t));
    }

    public void onMessage(WebSocket webSocket, String text) {
        this.onFrame((WebSocketFrame.Incoming)new WebSocketFrame.Text(text, true, (Option)None$.MODULE$));
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onFrame((WebSocketFrame.Incoming)new WebSocketFrame.Binary(bytes.toByteArray(), true, (Option)None$.MODULE$));
    }

    public void onOpen(WebSocket webSocket, Response response) {
        this.isOpen.set(true);
        this.queue.offer((Object)new WebSocketEvent.Open());
    }

    private void onFrame(WebSocketFrame.Incoming f) {
        this.queue.offer((Object)new WebSocketEvent.Frame(f));
    }

    public AddToQueueListener(AsyncQueue<F, WebSocketEvent> queue, AtomicBoolean isOpen) {
        this.queue = queue;
        this.isOpen = isOpen;
    }
}

